/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "text_element.h"

#include "load_param.h"
#include "factory.h"

#include "graphics_engine.h"
#include "state.h"


using namespace std;


CREATE_FACTORY(TextElement, CL_TEXT_ELEMENT);


/**
 * standart constructor
 */
TextElement::TextElement (const TiXmlElement* root)
{
  this->setClassID(CL_TEXT_ELEMENT, "TextElement");
  this->setName("TextElement");

  this->setLayer(E2D_LAYER_TOP);
  this->setSize(GraphicsEngine::getInstance()->getResolutionX()/10.0);

  this->setSize(20);
  this->setFont("fonts/earth.ttf");
  this->setAlignment(TEXT_ALIGN_CENTER);

  if(root != NULL)
    this->loadParams(root);
}


/**
 * destroys a TextElement
*/
TextElement::~TextElement ()
{
}


void TextElement::loadParams(const TiXmlElement* root)
{
  Element2D::loadParams(root);

  LoadParam(root, "size", this, Text, setSize);

  LoadParam(root, "text", this, TextElement, setText);

  LoadParam(root, "font", this, TextElement, setFont);
}

void TextElement::setText(const char* text)
{
  Text::setText(text);
}

void TextElement::setFont(const char* font)
{
  Text::setFont(font, (unsigned int)this->getSizeY2D());
}
