

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "story_entity.h"

#include "resource_manager.h"
#include "load_param.h"


using namespace std;


/**
 *  default constructor initializes all needed data
 */
StoryEntity::StoryEntity ()
{
  this->setClassID(CL_STORY_ENTITY, "StoryEntity");

  this->isInit = false;
  this->isPaused = false;
  this->isRunning = false;

  this->loadFile = NULL;
  this->storyID = -1;
  this->description = NULL;
  this->menuItemImage = NULL;
  this->menuScreenshoot = NULL;
  this->nextStoryID = WORLD_ID_GAMEEND;
  this->bMenuEntry = false;
}


/**
 *  deconstructor
 */
StoryEntity::~StoryEntity ()
{}


/**
 *  loads the Parameters of a Campaign
 * @param root: The XML-element to load from
 */
void StoryEntity::loadParams(const TiXmlElement* root)
{
  BaseObject::loadParams(root);

  LoadParam(root, "identifier", this, StoryEntity, setStoryID)
  .describe("A Unique Identifier for this StoryEntity");

  LoadParam(root, "path", this, StoryEntity, setLoadFile)
  .describe("DEPRICATED FORM OF file. The Filename of this StoryEntity (relative from the data-dir)");

  LoadParam(root, "file", this, StoryEntity, setLoadFile)
  .describe("The Filename of this StoryEntity (relative from the data-dir)");

  LoadParam(root, "nextid", this, StoryEntity, setNextStoryID)
  .describe("Sets the ID of the next StoryEntity");

  LoadParam(root, "menu-entry", this, StoryEntity, addToGameMenu)
      .describe("If this entry is 1, the world is contained in the SimpleGameMenu");


  LoadParam(root, "description", this, StoryEntity, setDescription)
      .describe("Sets the description of this StoryEntity");

  LoadParam(root, "menu-item-image", this, StoryEntity, setMenuItemImage)
      .describe("If this entry is 1, the world is contained in the SimpleGameMenu");

  LoadParam(root, "screenshoot", this, StoryEntity, setMenuScreenshoot)
      .describe("If this entry is 1, the world is contained in the SimpleGameMenu");

  PRINTF(4)("Loaded StoryEntity specific stuff\n");
}


/**
 *  sets the track path of this world
 * @param name the name of the path
 */
void StoryEntity::setLoadFile(const char* fileName)
{
  if (this->loadFile)
    delete this->loadFile;
  if (ResourceManager::isFile(fileName))
  {
    this->loadFile = new char[strlen(fileName)+1];
    strcpy(this->loadFile, fileName);
  }
  else
    this->loadFile = ResourceManager::getFullName(fileName);

  this->grabWorldInfo();
}


/**
 * sets the descroption of this StoryEntity
 * @param name name
 */
void StoryEntity::setDescription(const char* description)
{
  if (this->description)
    delete[] this->description;
  if (description!= NULL)
  {
    this->description= new char[strlen(description)+1];
    strcpy(this->description, description);
  }
  else this->description= NULL;
}

/**
 * sets the id of the next story entity: StoryEntities can choose their following entity themselfs.
 * the entity id defined here  will be startet after this entity ends. this can be convenient if you
 * want to have a non linear story with switches.
 * @param nextStoryID the story id of the next StoryEntity
 */
void StoryEntity::setNextStoryID(int nextStoryID)
{
  this->nextStoryID = nextStoryID;
}

/**
 * @brief grabs settings needed for displaying a MenuScreen.
 */
void StoryEntity::grabWorldInfo()
{
  PRINTF(3)("Grabbing the Worlds Settings\n", this->getLoadFile());
  if( getLoadFile() == NULL)
    return;
  TiXmlDocument XMLDoc(this->getLoadFile());
  // load the xml world file for further loading
  if( !XMLDoc.LoadFile())
  {
    PRINTF(1)("loading XML File: %s @ %s:l%d:c%d\n", XMLDoc.ErrorDesc(), this->getLoadFile(), XMLDoc.ErrorRow(), XMLDoc.ErrorCol());
    return;
  }
  TiXmlElement* root = XMLDoc.RootElement();
  if (root == NULL)
    return;

  if (root->Value() != NULL && !strcmp(root->Value(), "WorldDataFile"))
  {
    BaseObject::loadParams(root);

    LoadParam(root, "description", this, StoryEntity, setDescription)
    .describe("Sets the description of this StoryEntity");

    LoadParam(root, "menu-item-image", this, StoryEntity, setMenuItemImage)
    .describe("If this entry is 1, the world is contained in the SimpleGameMenu");

    LoadParam(root, "screenshoot", this, StoryEntity, setMenuScreenshoot)
    .describe("If this entry is 1, the world is contained in the SimpleGameMenu");
  }
}

/**
 * sets the menu item image of this StoryEntity
 * @param name name
 */
void StoryEntity::setMenuItemImage(const char* image)
{
  if (this->menuItemImage)
    delete[] this->menuItemImage;
  if (image != NULL)
  {
    this->menuItemImage = new char[strlen(image)+1];
    strcpy(this->menuItemImage, image);
  }
  else this->menuItemImage = NULL;
}


/** sets the menu screenshoot of this StoryEntity @param name name */
void StoryEntity::setMenuScreenshoot(const char* image)
{
  if (this->menuScreenshoot)
    delete[] this->menuScreenshoot;
  if (image != NULL)
  {
    this->menuScreenshoot = new char[strlen(image)+1];
    strcpy(this->menuScreenshoot, image);
  }
  else this->menuScreenshoot = NULL;
}


