
/*!
 * @file game_rules.h
 * Defines game rules for this game
 */

#ifndef _GAME_RULES_H
#define _GAME_RULES_H

#include "base_object.h"


class TiXmlElement;
class ObjectManager;


class GameRules : public BaseObject
{

  public:
    GameRules(const TiXmlElement root);
    virtual ~GameRules();

    virtual void loadParams(const TiXmlElement* root);


    virtual void tick(float dt) = 0;


  private:
    ObjectManager*         pObjectManager;         //!< reference to the current Object Manager
};


#endif /* _GAME_RULES_H */
