/*!
 * @file obb_tree.h
  *  Definition of an obb tree (object oriented Bounding Box)

*/

#ifndef _OBB_TREE_H
#define _OBB_TREE_H

#include "bv_tree.h"
#include "model.h"
#include "material.h"

class Material;
class OBBTreeNode;
class PNode;
class WorldEntity;

//! A class for representing an obb tree
class OBBTree : public BVTree
{

  public:
    OBBTree(int depth, const modelInfo* modInfo, WorldEntity* entity);
    virtual ~OBBTree();
    void init();

    virtual void spawnBVTree(const modelInfo& modelInf);
    virtual void flushTree();

    virtual void collideWith(WorldEntity* entity1, WorldEntity* entity2);
    virtual void drawBV(int depth, int drawMode) const;

    /** returns the next if for the obb tree node @return integer id number of the next node */
    inline const int getID() { return ++this->id;}
    /** returns the root node of the bounding volume tree @return reference to the root node */
    inline OBBTreeNode* getRootNode() const { return this->rootNode; }
    inline WorldEntity* getOwner() const { return this->owner; }

    void debug();

  private:
    OBBTreeNode*         rootNode;                        //!< reference to the root node of the tree
    int                  id;                              //!< the next id of a obb tree node
    int                  depth;                           //!< the depth of the tree to generate
    WorldEntity*         owner;                           //!< owner
};

#endif /* _OBB_TREE_H */
