/*!
 * file gui_exec.h
 * File that holds the class that creates the execute-Options.
 */

#ifndef _GUI_EXEC_H
#define _GUI_EXEC_H

#include "gui.h"
#include "gui_element.h"
#include "gui_gtk.h"

class Widget;
class CheckButton;
using namespace std;
class IniParser;

//! Class that creates the execute-Options.
class GuiExec : public GuiElement
{
 private:
  CheckButton* saveSettings;   //!< A CheckBox for if the Options should be saved.

  char* confDir;               //!< The directory of the orxonox-configuration-files.
  char* confFile;              //!< The name of the .orxonox.conf(ig)-file.

  //! A struct that holds informations about variables.
  struct VarInfo
  {
    const char* variableName;  //!< The Name of this variable;
    const char* variableValue; //!< The Value this variable gets.
  };

 public:
  GuiExec();
  virtual ~GuiExec();

  void setConfDir(const char* confDir);
  void setConfFile(const char* confFile);
  const char* getConfigFile() const;
  int shouldsave();
  void writeToFile(Widget* widget);
  void writeFileText(Widget* widget, IniParser* parser, int depth);
  void readFromFile(Widget* widget);
  static void readFileText(Widget* widget, void* varInfo);
  Widget* locateGroup(Widget* widget, const char* groupName, int depth);

#ifdef HAVE_GTK2
  static int startOrxonox(GtkWidget *widget, void* data);
  static int quitGui(GtkWidget *widget, void* data);
#else /* HAVE_GTK2 */
  static int startOrxonox(void* widget, void* data);
  static int quitGui(void* widget, void* data);
#endif /* HAVE_GTK2 */
};

//! A simple hashtable
struct HashTable
{
  char* name;           //!< name of the entry
  char* value;          //!< value of the entry
  HashTable* next;      //!< pointer to the next entry
};


#endif /* _GUI_EXEC_H */
