/*!
 * @file simple_game_menu.h
 *  a StoryEntity that contains a simple game menu
 */

#ifndef _SIMPLE_GAME_MENU_H
#define _SIMPLE_GAME_MENU_H


#include "game_world.h"
#include "event_listener.h"
#include "game_world_data.h"
#include <vector>
#include "vector.h"


class SimpleGameMenuData;
class TiXmlElement;
class ImageEntity;



class MenuLayer
{
  public:
    MenuLayer() {}
    ~MenuLayer() {}


  public:
    std::vector<ImageEntity*>         menuList;                        //!< the list of the menu items
    std::vector<StoryEntity*>         storyList;                       //!< the list of the StoryEntities for the menu
};


//! a simple game menu based on a story entity
/**
 * This is a simple menu, that is based on the StoryEntity. Therefore this menu is absolutly
 * loadable and is exchangeable very easely :D
 */
class SimpleGameMenu : virtual public GameWorld, virtual public EventListener
{

  public:
    SimpleGameMenu(const TiXmlElement* root = NULL);
    virtual ~SimpleGameMenu();

    virtual void loadParams(const TiXmlElement* root);

    virtual ErrorMessage init();
    virtual ErrorMessage loadData();
    virtual ErrorMessage unloadData();

    virtual bool start();
    virtual bool stop();

    virtual void process(const Event &event);


  protected:
    virtual void tick();
    virtual void collide();


  private:
    void animateScene(float dt);
    void switchMenuLayer(int layer1, int layer2);


  private:
    std::vector<MenuLayer*>           menuLayer;                       //!< the menu layer
    MenuLayer*                        selectedLayer;                   //!< the selected menu layer
    int                               layerIndex;

    //std::vector<ImageEntity*>         menuList;                        //!< the list of the menu items
    ImageEntity*                      menuSelected;                    //!< ref to the selected menu entity
    ImageEntity*                      menuSelector;                    //!< ref to the selector image
    ImageEntity*                      menuStartGame;
    ImageEntity*                      menuStartMultiplayerGame;
    ImageEntity*                      menuQuitGame;
    int                               menuSelectedIndex;

    Vector                            cameraVector;
};



//! the simple game menu data
class SimpleGameMenuData : public GameWorldData
{

  public:
    SimpleGameMenuData();
    virtual ~SimpleGameMenuData();

    virtual ErrorMessage init();


  protected:
    virtual ErrorMessage loadGUI(TiXmlElement* root);
    virtual ErrorMessage loadWorldEntities(TiXmlElement* root);
    virtual ErrorMessage loadScene(TiXmlElement* root);

    virtual ErrorMessage unloadGUI();
    virtual ErrorMessage unloadWorldEntities();
    virtual ErrorMessage unloadScene();

};


#endif /* _GAME_WORLD_H */
