

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer:
*/


#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD


#include "story_entity.h"

#include "load_param.h"


using namespace std;


/**
 *  default constructor initializes all needed data
 */
StoryEntity::StoryEntity ()
{
  this->setClassID(CL_STORY_ENTITY, "StoryEntity");

  this->isInit = false;
  this->isPaused = false;
  this->isRunning = false;

  this->storyID = -1;
  this->description = NULL;
  this->menuItemImage = NULL;
  this->nextStoryID = WORLD_ID_GAMEEND;
  this->bMenuEntry = false;
}


/**
 *  deconstructor
 */
StoryEntity::~StoryEntity ()
{}


/**
 *  loads the Parameters of a Campaign
 * @param root: The XML-element to load from
 */
void StoryEntity::loadParams(const TiXmlElement* root)
{
  BaseObject::loadParams(root);

  LoadParam(root, "identifier", this, StoryEntity, setStoryID)
      .describe("A Unique Identifier for this StoryEntity");

  LoadParam(root, "nextid", this, StoryEntity, setNextStoryID)
      .describe("Sets the ID of the next StoryEntity");

  LoadParam(root, "description", this, StoryEntity, setDescription)
      .describe("Sets the description of this StoryEntity");

  LoadParam(root, "menu-entry", this, StoryEntity, addToGameMenu)
      .describe("If this entry is 1, the world is contained in the SimpleGameMenu");

  LoadParam(root, "menu-item-image", this, StoryEntity, setMenuItemImage)
      .describe("If this entry is 1, the world is contained in the SimpleGameMenu");

  LoadParam(root, "menu-screenshoot", this, StoryEntity, setMenuScreenshoot)
      .describe("If this entry is 1, the world is contained in the SimpleGameMenu");

  PRINTF(4)("Loaded StoryEntity specific stuff\n");
}


/**
 * sets the descroption of this StoryEntity
 * @param name name
 */
void StoryEntity::setDescription(const char* description)
{
  if (this->description)
    delete[] this->description;
  if (description!= NULL)
  {
    this->description= new char[strlen(description)+1];
    strcpy(this->description, description);
  }
  else this->description= NULL;
}


/**
 * sets the menu item image of this StoryEntity
 * @param name name
 */
void StoryEntity::setMenuItemImage(const char* image)
{
  if (this->menuItemImage)
    delete[] this->menuItemImage;
  if (image != NULL)
  {
    this->menuItemImage = new char[strlen(image)+1];
    strcpy(this->menuItemImage, image);
  }
  else this->menuItemImage = NULL;
}


/** sets the menu screenshoot of this StoryEntity @param name name */
void StoryEntity::setMenuScreenshoot(const char* image)
{
  if (this->menuScreenshoot)
    delete[] this->menuScreenshoot;
  if (image != NULL)
  {
    this->menuScreenshoot = new char[strlen(image)+1];
    strcpy(this->menuScreenshoot, image);
  }
  else this->menuScreenshoot = NULL;
}


