/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "image_entity.h"

#include "load_param.h"
#include "factory.h"

#include "graphics_engine.h"
#include "material.h"
#include "glincl.h"
#include "state.h"


using namespace std;


CREATE_FACTORY(ImageEntity, CL_IMAGE_ENTITY);


/**
 * standart constructor
 */
ImageEntity::ImageEntity (const TiXmlElement* root)
{
  this->init();
  if( root)
    this->loadParams(root);
}


/**
 * destroys a ImageEntity
*/
ImageEntity::~ImageEntity ()
{
  if (this->material)
    delete this->material;
}


/**
 * initializes the ImageEntity
 */
void ImageEntity::init()
{
  this->setClassID(CL_IMAGE_ENTITY, "ImageEntity");
  this->setName("ImageEntity");

  this->setLayer(E2D_LAYER_TOP);
  this->setRotationSpeed(5);
  this->setSize(GraphicsEngine::getInstance()->getResolutionX()/10.0, GraphicsEngine::getInstance()->getResolutionY()/10.0);

  this->setBindNode(this);
  this->material = new Material;
  this->setTexture("pictures/error_texture.png");
  this->bBillboarding = false;
}


void ImageEntity::loadParams(const TiXmlElement* root)
{
  PNode::loadParams(root);

  LoadParam(root, "texture", this, ImageEntity, setTexture)
      .describe("the texture-file to load onto the ImageEntity");

  LoadParam(root, "size", this, ImageEntity, setSize)
      .describe("the size of the ImageEntity in Pixels");

  LoadParam(root, "rotation-speed", this, ImageEntity, setRotationSpeed)
      .describe("the Speed with which the ImageEntity should rotate");

  LoadParam(root, "billboarding", this, ImageEntity, toggleBillboarding)
      .describe("sets the Billboard to always look in the direction of the Player");
}


/**
 * sets the size of the ImageEntity.
 * @param size the size in pixels
 */
void ImageEntity::setSize(float sizeX, float sizeY)
{
  this->setSize2D(sizeX, sizeY);
}


/**
 * sets the material to load
 * @param textureFile The texture-file to load onto the crosshair
 */
void ImageEntity::setTexture(const char* textureFile)
{
  this->material->setDiffuseMap(textureFile);
}


/** this turns on/off the billboarding of this WorldEntity
 *
 * This means that the image will always look in the direction of the Player
 */
void ImageEntity::toggleBillboarding()
{
  this->bBillboarding = !this->bBillboarding;
}


/**
 * ticks the ImageEntity
 * @param dt the time to ticks
 */
void ImageEntity::tick(float dt)
{
  // let the crosshair rotate
  //this->shiftDir2D(dt * rotationSpeed);


  float z = 0.0f;
  glReadPixels ((int)this->getAbsCoor2D().x,
                 GraphicsEngine::getInstance()->getResolutionY()-(int)this->getAbsCoor2D().y-1,
                 1,
                 1,
                 GL_DEPTH_COMPONENT,
                 GL_FLOAT,
                 &z);


  GLdouble objX=.0, objY=.0, objZ=.0;
  gluUnProject(this->getAbsCoor2D().x,
               GraphicsEngine::getInstance()->getResolutionY()-this->getAbsCoor2D().y-1,
               .99,  // z
               GraphicsEngine::modMat,
               GraphicsEngine::projMat,
               GraphicsEngine::viewPort,
               &objX,
               &objY,
               &objZ );

  //this->setAbsCoor(objX, objY, objZ);
}


/**
 * draws the crosshair
 */
void ImageEntity::draw() const
{
  glPushMatrix();
  glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0);

  //glRotatef(this->getAbsDir2D(), 0,0,1);
  this->material->select();
  glBegin(GL_TRIANGLE_STRIP);
  glTexCoord2f(0, 0);
  glVertex2f(-this->getSizeX2D(), -this->getSizeY2D());
  glTexCoord2f(1, 0);
  glVertex2f(this->getSizeX2D(), -this->getSizeY2D());
  glTexCoord2f(0, 1);
  glVertex2f(-this->getSizeX2D(), this->getSizeY2D());
  glTexCoord2f(1, 1);
  glVertex2f(this->getSizeX2D(), this->getSizeY2D());
  glEnd();
  glPopMatrix();

}
