

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_STORY_ENTITY

#include "campaign.h"

#include "factory.h"
#include "load_param.h"

#include "campaign_data.h"

using namespace std;


/**
 *  the constructor
 * @param root the XML root element
 *
 * this constructor is always called in a XML context (loading procedure)
 */
Campaign::Campaign ( TiXmlElement* root)
{
  this->setClassID(CL_CAMPAIGN, "Campaign");

  PRINTF(4)("Loading Campaign...\n");
  assert( root != NULL);

  this->campaignData = new CampaignData(root);
  this->loadParams(root);

}


/**
 * the campaign destructor
 */
Campaign::~Campaign ()
{
  if( this->campaignData)
    delete this->campaignData;
}


/**
 *  loads the Parameters of a Campaign
 * @param root: The XML-element to load from
 */
void Campaign::loadParams(const TiXmlElement* root)
{
  StoryEntity::loadParams(root);

  PRINTF(4)("Loaded Campaign specific stuff\n");
}


/**
 *  starts the campaing with a specific ID
 * @param storyID the id of the StoryEntity
 */
bool Campaign::start()
{
  PRINTF(2)("Starting Campaign nr. %i\n", this->getStoryID());

  this->isRunning = true;
  this->run();
}


/**
 *  pauses the campaign
 */
bool Campaign::pause()
{
  this->isPaused = true;
}


/**
 *  resumes the campaign after a pause
 */
bool Campaign::resume()
{
  PRINTF(4)("Resuming the current Campaign\n");
  this->isPaused = false;
}


/**
 *  stops the campaign
 */
bool Campaign::stop()
{
  PRINTF(4)("Stopping the current Campaign\n");
  this->isRunning = false;
  if( this->currentEntity != NULL)
  {
    this->currentEntity->stop();
  }
}


/**
 *  runs the campaign
 */
void Campaign::run()
{
  ErrorMessage       errorCode;
  int                storyID = WORLD_ID_0;

  for( this->currentEntity = this->campaignData->getFirstLevel(), this->isRunning = true;
       this->currentEntity != NULL && this->isRunning;
       this->currentEntity = this->campaignData->getNextLevel())
  {
    PRINTF(0)("Campaign is starting StoryEntity nr:%i\n", this->currentEntity->getStoryID());

    this->currentEntity->init();

    this->currentEntity->loadData();
    this->currentEntity->start();
    this->currentEntity->unloadData();
  }
  PRINTF(2)("There is no StoryEnity left to play, quitting\n");
}


/**
 *  this changes to the next level
 */
void Campaign::switchToNextLevel()
{
  PRINTF(4)("Switching to the next StoryEntity\n");
  this->currentEntity->stop();
}


