/*!
 * @file box_emitter.h
 *  Definition of a BoxEmitter
 */

#ifndef _BOX_EMITTER_H
#define _BOX_EMITTER_H

#include "particle_emitter.h"

#define BOX_EMITTER_DEFAULT_SIZE Vector(1.0f, 1.0f, 1.0f)

//! A class to handle a Box Emitter.
/**
 * A Box Emitter is a special kind of emitter, that has the (underlying) PNode
 * at its center, and from there on is a Box in the Direction of the PNode
 * out around size in the corresponding directions
 */
class BoxEmitter : public ParticleEmitter
{
  friend class ParticleSystem;
public:
  BoxEmitter(const Vector& size = BOX_EMITTER_DEFAULT_SIZE,
             float emissionRate = PARTICLE_EMITTER_DEFAULT_EMISSION_RATE,
             float velocity = PARTICLE_EMITTER_DEFAULT_VELOCITY,
             float angle = PARTICLE_EMITTER_DEFAULT_SPREAD);
  BoxEmitter(const TiXmlElement* root);
  virtual ~BoxEmitter();

  virtual void loadParams(const TiXmlElement* root);

  void setSize(float x, float y, float z);
  void setSize(const Vector& size) { this->setSize(size.x, size.y, size.z); };

protected:
  virtual void emitParticles(unsigned int count) const;

private:
  void init();

private:
  Vector      size;
};

#endif /* _BOX_EMITTER_H */
