/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "rocket.h"

#include "fast_factory.h"

#include "state.h"
#include "class_list.h"

#include "dot_emitter.h"
#include "sprite_particles.h"


using namespace std;

CREATE_FAST_FACTORY_STATIC(Rocket, CL_ROCKET);

/**
 *  standard constructor
*/
Rocket::Rocket () : Projectile()
{
  this->setClassID(CL_ROCKET, "Rocket");

  float modelSize = .3;
  this->loadModel("models/projectiles/orx-rocket.obj", .3);

  this->setMinEnergy(1);
  this->setHealthMax(10);
  this->lifeSpan = 5;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 *  standard deconstructor
*/
Rocket::~Rocket ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (Rocket::trailParticles != NULL && ClassList::getList(CL_ROCKET)->size() <= 1)
  {
/*    if (ClassList::exists(Rocket::trailParticles, CL_PARTICLE_SYSTEM))
      delete Rocket::trailParticles;*/
    Rocket::trailParticles = NULL;
  }
  if (Rocket::explosionParticles != NULL && ClassList::getList(CL_ROCKET)->size() <= 1)
  {
/*    if (ClassList::exists(Rocket::explosionParticles, CL_PARTICLE_SYSTEM))
      delete Rocket::explosionParticles;*/
    Rocket::explosionParticles = NULL;
  }

}

SpriteParticles* Rocket::trailParticles = NULL;
SpriteParticles* Rocket::explosionParticles = NULL;

void Rocket::activate()
{
  if (unlikely(Rocket::trailParticles == NULL))
  {
    Rocket::trailParticles = new SpriteParticles(2000);
    Rocket::trailParticles->setName("RocketTrailParticles");
    Rocket::trailParticles->setMaterialTexture("maps/radial-trans-noise.png");
    Rocket::trailParticles->setLifeSpan(1.0, .3);
    Rocket::trailParticles->setRadius(0.0, .5);
    Rocket::trailParticles->setRadius(0.2, 2.0);
    Rocket::trailParticles->setRadius(.5, .8);
    Rocket::trailParticles->setRadius(1.0, .8);
    Rocket::trailParticles->setColor(0.0, 1,0,0,.7);
    Rocket::trailParticles->setColor(0.2, .8,.8,0,.5);
    Rocket::trailParticles->setColor(0.5, .8,.8,.8,.8);
    Rocket::trailParticles->setColor(1.0, .8,.8,.8,.0);
  }
  if (unlikely(Rocket::explosionParticles == NULL))
  {
    Rocket::explosionParticles = new SpriteParticles(200);
    Rocket::explosionParticles->setName("RocketExplosionParticles");
    Rocket::explosionParticles->setMaterialTexture("maps/radial-trans-noise.png");
    Rocket::explosionParticles->setLifeSpan(.5, .3);
    Rocket::explosionParticles->setRadius(0.0, 10);
    Rocket::explosionParticles->setRadius(.5, 15.0);
    Rocket::explosionParticles->setRadius(1.0, 10.0);
    Rocket::explosionParticles->setColor(0.0, 0,1,0,1);
    Rocket::explosionParticles->setColor(0.5, .8,.8,0,.8);
    Rocket::explosionParticles->setColor(0.8, .8,.8,.3,.8);
    Rocket::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  this->emitter->setSystem(Rocket::trailParticles);

  this->updateNode(0);
  this->emitter->setEmissionRate(45.0);
  this->emitter->setEmissionVelocity(0.0);
}


void Rocket::deactivate()
{
  this->emitter->setSystem(NULL);
  this->lifeCycle = 0.0;
  this->toList(OM_NULL);

//  GarbageCollector::getInstance()->collect(this);
  this->toList(OM_DEAD);
  Rocket::fastFactory->kill(this);
}


void Rocket::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity)
    this->destroy();
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void Rocket::tick (float dt)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * (dt);
  this->shiftCoor(v);

  if(this->tickLifeCycle(dt))
    this->deactivate();
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void Rocket::destroy ()
{
  PRINTF(5)("DESTROY Rocket\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
  this->emitter->setSystem(Rocket::explosionParticles);

  this->emitter->setEmissionRate(1000.0);
  this->emitter->setEmissionVelocity(50.0);
//  this->deactivate();

}


void Rocket::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->getModel()->draw();

  glPopMatrix();
}

