/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Silvan Nellen
   co-programmer:

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "guided_missile.h"

#include "fast_factory.h"

#include "state.h"
#include "class_list.h"

#include "dot_emitter.h"
#include "sprite_particles.h"

using namespace std;

CREATE_FAST_FACTORY_STATIC(GuidedMissile, CL_GUIDED_MISSILE);

/**
 *  standard constructor
*/
GuidedMissile::GuidedMissile () : Projectile()
{
  this->setClassID(CL_GUIDED_MISSILE, "GuidedMissile");

  float modelSize = .3;
  this->loadModel("models/projectiles/orx-rocket.obj", .3);

  this->setMinEnergy(1);
  this->setHealthMax(10);
  this->lifeSpan = 10.0;
  this->agility = 10;
  this->maxVelocity = 75;

  this->emitter = new DotEmitter(100, 5, M_2_PI);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 *  standard deconstructor
*/
GuidedMissile::~GuidedMissile ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (GuidedMissile::trailParticles != NULL && ClassList::getList(CL_GUIDED_MISSILE)->size() <= 1)
  {
    if (ClassList::exists(GuidedMissile::trailParticles, CL_PARTICLE_SYSTEM))
      delete GuidedMissile::trailParticles;
    GuidedMissile::trailParticles = NULL;
  }
  if (GuidedMissile::explosionParticles != NULL && ClassList::getList(CL_GUIDED_MISSILE)->size() <= 1)
  {
    if (ClassList::exists(GuidedMissile::explosionParticles, CL_PARTICLE_SYSTEM))
      delete GuidedMissile::explosionParticles;
    GuidedMissile::explosionParticles = NULL;
  }

}

SpriteParticles* GuidedMissile::trailParticles = NULL;
SpriteParticles* GuidedMissile::explosionParticles = NULL;



void GuidedMissile::activate()
{
  if (unlikely(GuidedMissile::trailParticles == NULL))
  {
    GuidedMissile::trailParticles = new SpriteParticles(2000);
    GuidedMissile::trailParticles->setName("GuidedMissileTrailParticles");
    GuidedMissile::trailParticles->setMaterialTexture("maps/radial-trans-noise.png");
    GuidedMissile::trailParticles->setLifeSpan(1.0, .3);
    GuidedMissile::trailParticles->setRadius(0.0, .5);
    GuidedMissile::trailParticles->setRadius(0.2, 2.0);
    GuidedMissile::trailParticles->setRadius(.5, .8);
    GuidedMissile::trailParticles->setRadius(1.0, .8);
    GuidedMissile::trailParticles->setColor(0.0, 1,0,0,.7);
    GuidedMissile::trailParticles->setColor(0.2, .8,.8,0,.5);
    GuidedMissile::trailParticles->setColor(0.5, .8,.8,.8,.8);
    GuidedMissile::trailParticles->setColor(1.0, .8,.8,.8,.0);
  }
  if (unlikely(GuidedMissile::explosionParticles == NULL))
  {
    GuidedMissile::explosionParticles = new SpriteParticles(200);
    GuidedMissile::explosionParticles->setName("GuidedMissileExplosionParticles");
    GuidedMissile::explosionParticles->setMaterialTexture("maps/radial-trans-noise.png");
    GuidedMissile::explosionParticles->setLifeSpan(.5, .3);
    GuidedMissile::explosionParticles->setRadius(0.0, 10);
    GuidedMissile::explosionParticles->setRadius(.5, 15.0);
    GuidedMissile::explosionParticles->setRadius(1.0, 10.0);
    GuidedMissile::explosionParticles->setColor(0.0, 0,1,0,1);
    GuidedMissile::explosionParticles->setColor(0.5, .8,.8,0,.8);
    GuidedMissile::explosionParticles->setColor(0.8, .8,.8,.3,.8);
    GuidedMissile::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  this->emitter->setSystem(GuidedMissile::trailParticles);

  this->updateNode(0);
  this->emitter->setEmissionRate(45.0);
  this->emitter->setEmissionVelocity(0.0);
}


void GuidedMissile::deactivate()
{
  this->emitter->setSystem(NULL);
  this->lifeCycle = 0.0;

  this->toList(OM_DEAD);
  this->removeNode();
  GuidedMissile::fastFactory->kill(this);
}


void GuidedMissile::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity)
    this->destroy();
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void GuidedMissile::tick (float time)
{


if (this->target != NULL && this->target->getParent() != PNode::getNullParent())
   {
    speed = velocity.len();
    diffVector = ((target->getAbsCoor() - this->getAbsCoor()).getNormalized());

    if(velocity.dot(diffVector) != 0)
     {
     correctionVector = (( ( diffVector *  (speed * speed/( velocity.dot(diffVector ) ) )) - velocity).getNormalized()) * agility;

      if( (diffVector *  (speed * speed/( velocity.dot(diffVector ) ) ) -velocity).len() < agility )
       velocity = ((diffVector *  (speed * speed/( velocity.dot(diffVector ) ) )).getNormalized())*agility;
      else if(velocity.dot(diffVector) > 0)
        velocity += correctionVector;
      else if (velocity.dot(diffVector) < 0)
        velocity -= correctionVector;
     }
    else
      velocity += diffVector * agility;

     this->setAbsDir(Quaternion(velocity, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)));
   }

  velocity *= maxVelocity/velocity.len();
  Vector v = this->velocity * (time);
  this->shiftCoor(v);

  if(this->tickLifeCycle(time))
    this->deactivate();
}

/**
 *  the function gets called, when the projectile is destroyed
 */
void GuidedMissile::destroy ()
{
  PRINTF(5)("DESTROY GuidedMissile\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
  this->emitter->setSystem(GuidedMissile::explosionParticles);

  this->emitter->setEmissionRate(1000.0);
  this->emitter->setEmissionVelocity(50.0);
//  this->deactivate();

}


void GuidedMissile::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->getModel()->draw();

  glPopMatrix();

}

