/*!
 * @file dot_emitter.h
 *  Definition of a DotEmitter
 */

#ifndef _DOT_EMITTER_H
#define _DOT_EMITTER_H

#include "particle_emitter.h"

//! A class to handle an Emitter.
class DotEmitter : public ParticleEmitter
{
  friend class ParticleSystem;
public:
  DotEmitter(float emissionRate = 1.0, float velocity = 1.0, float angle = .5);
  DotEmitter(const TiXmlElement* root);
  virtual ~DotEmitter();

protected:
  virtual void emitParticles(unsigned int count) const;

private:
  void init();
};

#endif /* _DOT_EMITTER_H */
