/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "box_emitter.h"

#include "particle_system.h"

#include "load_param.h"
#include "factory.h"
#include "debug.h"
#include "stdlibincl.h"

using namespace std;


CREATE_FACTORY(BoxEmitter, CL_BOX_EMITTER);

/**
 *  standard constructor
*/
BoxEmitter::BoxEmitter(const Vector& size, float emissionRate, float velocity, float angle)
    :  ParticleEmitter(emissionRate, velocity, angle)
{
  this->init();
  this->setSize(size);
}

/**
 *  constructs and loads a BoxEmitter from a XML-element
 * @param root the XML-element to load from
*/
BoxEmitter::BoxEmitter(const TiXmlElement* root)
    : ParticleEmitter()
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard destructor

   removes the EmitterSystem from the ParticleEngine
*/
BoxEmitter::~BoxEmitter ()
{
  this->setSystem(NULL);
}

/**
  @brief initializes default values of a ParitcleEmitter
*/
void BoxEmitter::init()
{
  this->setClassID(CL_BOX_EMITTER, "BoxEmitter");
  this->setSize(1.0f,1.0f,1.0f);
}

void BoxEmitter::loadParams(const TiXmlElement* root)
{
  ParticleEmitter::loadParams(root);

  LoadParam(root, "size", this, BoxEmitter, setSize)
  .describe("The Size of the BoxEmitter: x, y, z")
  .defaultValues(3, 1.0f,1.0f,1.0f);
}

void BoxEmitter::emitParticles(unsigned int count) const
{
  Vector inheritVelocity = this->getVelocity() * this->inheritSpeed;

  for (unsigned int i = 0; i < count; i++)
  {
    Vector randDir = Vector(rand()-RAND_MAX/2, rand()-RAND_MAX/2, rand()-RAND_MAX/2);
    randDir.normalize();
    randDir = (Quaternion(angle + randomAngle *((float)rand()/RAND_MAX -.5), randDir)).apply(this->getAbsDirX());
    Vector velocityV = randDir.getNormalized()*this->velocity + inheritVelocity;

    Vector extension = Vector(((float)rand()/RAND_MAX -.5)*this->size.x,
                              ((float)rand()/RAND_MAX -.5) *this->size.y,
                              ((float)rand()/RAND_MAX -.5) * this->size.z);


    // ROTATIONAL CALCULATION (this must not be done for all types of particles.)
    randDir = Vector(rand()-RAND_MAX/2, rand()-RAND_MAX/2, rand()-RAND_MAX/2);
    randDir.normalize();
    Quaternion orient = Quaternion(M_PI, randDir);
    Quaternion moment = Quaternion(this->momentum + this->momentumRandom, randDir);

    this->getSystem()->addParticle(this->getAbsCoor() + extension, velocityV, orient, moment);

  }
}
