/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer: Benjamin Grauer

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "test_bullet.h"

#include "fast_factory.h"

#include "state.h"
#include "class_list.h"

#include "dot_emitter.h"
#include "sprite_particles.h"


using namespace std;

CREATE_FAST_FACTORY_STATIC(TestBullet, CL_TEST_BULLET);

/**
 *  standard constructor
*/
TestBullet::TestBullet () : Projectile()
{
  this->setClassID(CL_TEST_BULLET, "TestBullet");

  float modelSize = .3;
  this->loadModel("models/projectiles/orx-rocket.obj", .3);

  this->setMinEnergy(1);
  this->setHealthMax(10);
  this->lifeSpan = 2;

  this->emitter = new DotEmitter(Vector(0,1,0), M_2_PI, 100, 5);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 *  standard deconstructor
*/
TestBullet::~TestBullet ()
{
  // delete this->emitter;

  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (TestBullet::trailParticles != NULL && ClassList::getList(CL_TEST_BULLET)->size() <= 1)
  {
    if (ClassList::exists(TestBullet::trailParticles, CL_PARTICLE_SYSTEM))
      delete TestBullet::trailParticles;
    TestBullet::trailParticles = NULL;
  }
  if (TestBullet::explosionParticles != NULL && ClassList::getList(CL_TEST_BULLET)->size() <= 1)
  {
    if (ClassList::exists(TestBullet::explosionParticles, CL_PARTICLE_SYSTEM))
      delete TestBullet::explosionParticles;
    TestBullet::explosionParticles = NULL;
  }

}

SpriteParticles* TestBullet::trailParticles = NULL;
SpriteParticles* TestBullet::explosionParticles = NULL;

void TestBullet::activate()
{
  if (unlikely(TestBullet::trailParticles == NULL))
  {
    TestBullet::trailParticles = new SpriteParticles(1000);
    TestBullet::trailParticles->setName("TestBulletTrailParticles");
    TestBullet::trailParticles->setLifeSpan(.5, .3);
    TestBullet::trailParticles->setRadius(0.0, .5);
    TestBullet::trailParticles->setRadius(0.5, 2.0);
    TestBullet::trailParticles->setRadius(1.0, 5.0);
    TestBullet::trailParticles->setColor(0.0, 1,0,0,.7);
    TestBullet::trailParticles->setColor(0.5, .8,.8,0,.5);
    TestBullet::trailParticles->setColor(1.0, .7,.7,.7,.0);
  }
  if (unlikely(TestBullet::explosionParticles == NULL))
  {
    TestBullet::explosionParticles = new SpriteParticles(1000);
    TestBullet::explosionParticles->setName("TestBulletExplosionParticles");
    TestBullet::explosionParticles->setLifeSpan(.5, .3);
    TestBullet::explosionParticles->setRadius(0.0, 10);
    TestBullet::explosionParticles->setRadius(.5, 20.0);
    TestBullet::explosionParticles->setRadius(1.0, 3.0);
    TestBullet::explosionParticles->setColor(0.0, 0,1,0,.9);
    TestBullet::explosionParticles->setColor(0.5, .8,.8,0,.5);
    TestBullet::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  this->emitter->setSystem(TestBullet::trailParticles);

  this->emitter->setEmissionRate(20.0);
  this->emitter->setEmissionVelocity(3.0);
}


void TestBullet::deactivate()
{
  this->emitter->setSystem(NULL);
  this->lifeCycle = 0.0;
  this->toList(OM_NULL);

  TestBullet::fastFactory->kill(this);
}


void TestBullet::collidesWith(WorldEntity* entity, const Vector& location)
{
  if (this->hitEntity != entity && entity->isA(CL_NPC))
    this->destroy();
  this->hitEntity = entity;
}

/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void TestBullet::tick (float time)
{
  //Vector v = *this->flightDirection * ( this->speed * time * 1000 + 0.1);
  Vector v = this->velocity * (time);
  this->shiftCoor(v);

  this->lifeCycle += time/this->lifeSpan;
  if( this->lifeCycle >= 1.0)
    {
      PRINTF(5)("FINALIZE==========================\n");
      PRINTF(5)("current life cycle is: %f\n", this->lifeCycle);
      PRINTF(5)("FINALIZE===========================\n");

      this->deactivate();
    }
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void TestBullet::destroy ()
{
  PRINTF(5)("DESTROY TestBullet\n");
  this->lifeCycle = .95; //!< @todo calculate this usefully.
  this->emitter->setSystem(TestBullet::explosionParticles);

  this->emitter->setEmissionRate(30.0);
  this->emitter->setEmissionVelocity(50.0);
//  this->deactivate();

}


void TestBullet::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, 2.0, 2.0);
  this->getModel()->draw();

  glPopMatrix();
}

