/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Benjamin Grauer
   co-programmer: ...

*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "hyperblast.h"

#include "fast_factory.h"

#include "state.h"
#include "class_list.h"

#include "dot_emitter.h"
#include "sprite_particles.h"
#include "spark_particles.h"


using namespace std;

CREATE_FAST_FACTORY_STATIC(Hyperblast, CL_HYPERBLAST);

/**
 *  standard constructor
*/
Hyperblast::Hyperblast () : Projectile()
{
  this->setClassID(CL_HYPERBLAST, "Hyperblast");

  float modelSize = .3;
  this->loadModel("models/projectiles/hyperblast.obj", 5);

  this->setMinEnergy(1);
  this->setHealthMax(10);
  this->lifeSpan = 1;
  this->size = 4.0;

  this->emitter = new DotEmitter(Vector(0,1,0), M_2_PI, 100, 5);
  this->emitter->setParent(this);
  this->emitter->setSpread(M_PI, M_PI);
}


/**
 *  standard deconstructor
*/
Hyperblast::~Hyperblast ()
{
  /* this is normaly done by World.cc by deleting the ParticleEngine */
  if (Hyperblast::explosionParticles != NULL && ClassList::getList(CL_HYPERBLAST)->size() <= 1)
  {
    Hyperblast::explosionParticles = NULL;
  }

}

SparkParticles* Hyperblast::explosionParticles = NULL;

void Hyperblast::activate()
{
  if (unlikely(Hyperblast::explosionParticles == NULL))
  {
    Hyperblast::explosionParticles = new SparkParticles(2000);
    Hyperblast::explosionParticles->setName("HyperblastExplosionParticles");
    Hyperblast::explosionParticles->setLifeSpan(2, .3);
    Hyperblast::explosionParticles->setRadius(0.1, .1);
    Hyperblast::explosionParticles->setRadius(0.2, .2);
    Hyperblast::explosionParticles->setRadius(1.0, .1);
    Hyperblast::explosionParticles->setColor(0.0, 1.0, .6, 0 ,1);
    Hyperblast::explosionParticles->setColor(0.5, .8,.1,0,.6);
    Hyperblast::explosionParticles->setColor(0.8, .8,.2,.3,.3);
    Hyperblast::explosionParticles->setColor(1.0, 1,1,1,.0);
  }

  this->emitter->setSystem(Hyperblast::explosionParticles);
  this->size = 4.0;

  Hyperblast::explosionParticles->debug();
  this->updateNode(0);
  this->emitter->setEmissionRate(5000.0);
  this->emitter->setEmissionVelocity(50.0);
}


void Hyperblast::deactivate()
{
  this->emitter->setSystem(NULL);
  this->lifeCycle = 0.0;
  this->toList(OM_NULL);

//  GarbageCollector::getInstance()->collect(this);
  this->toList(OM_DEAD);
  Hyperblast::fastFactory->kill(this);
}


void Hyperblast::collidesWith(WorldEntity* entity, const Vector& location)
{
}

/**
 *  signal tick, time dependent things will be handled here
 * @param time since last tick
*/
void Hyperblast::tick (float dt)
{
  if(this->tickLifeCycle(dt))
    this->deactivate();

  this->size *=(1 - (5.0*dt));

  if (this->lifeCycle > .1 && this->emitter->getEmissionRate() > 10.0)
    this->emitter->setEmissionRate(0.0);
}

/**
 *  the function gets called, when the projectile is destroyed
*/
void Hyperblast::destroy ()
{
  PRINTF(5)("DESTROY Hyperblast\n");


}


void Hyperblast::draw () const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  float matrix[4][4];
  glTranslatef (this->getAbsCoor ().x, this->getAbsCoor ().y, this->getAbsCoor ().z);
  this->getAbsDir().matrix (matrix);
  glMultMatrixf((float*)matrix);
  glScalef(2.0, this->size, this->size);
  this->getModel()->draw();

  glPopMatrix();
}

