/*!
 * @file dot_emitter.h
 *  Definition of a DotEmitter
 */

#ifndef _DOT_EMITTER_H
#define _DOT_EMITTER_H

#include "particle_emitter.h"

// Default values
#define DOT_EMITTER_DEFAULT_SIZE              1.0

//! A class to handle an Emitter.
class DotEmitter : public ParticleEmitter
{
  friend class ParticleSystem;
public:
  DotEmitter(const Vector& direction, float angle = .5,
             float emissionRate = 1.0, float velocity = 1.0);
  DotEmitter(const TiXmlElement* root);
  virtual ~DotEmitter();


  /* controlling the emitter: interface */
  void tick(float dt);

  virtual void emitParticles(unsigned int count) const;

private:
  void init();

private:
  Vector          emitterSize;       //!< The size of the emitter (not for EMITTER_DOT).

};

#endif /* _DOT_EMITTER_H */
