/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "spark_particles.h"

#include "load_param.h"
#include "factory.h"
#include "material.h"
#include "state.h"
#include "shell_command.h"

#include "parser/tinyxml/tinyxml.h"
#include <algorithm>



using namespace std;

CREATE_FACTORY(SparkParticles, CL_SPARK_PARTICLES);

/**
 *  standard constructor
 * @param maxCount the Count of particles in the System
 * @param type The Type of the SparkParticles
*/
SparkParticles::SparkParticles (unsigned int maxCount)
    : ParticleSystem(maxCount)
{
  this->init();
}

/**
 * @brief creates a Particle System out of a XML-element
 * @param root: the XML-element to load from
 */
SparkParticles::SparkParticles(const TiXmlElement* root)
{
  this->init();

  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
SparkParticles::~SparkParticles()
{ }

/**
 * @brief initializes the SparkParticles with default values
*/
void SparkParticles::init()
{
  this->setClassID(CL_SPARK_PARTICLES, "SparkParticles");

  this->material = NULL;
}


/**
 * loads Parameters from a TiXmlElement
 * @param root the XML-element to load from.
 */
void SparkParticles::loadParams(const TiXmlElement* root)
{
  ParticleSystem::loadParams(root);
}

/**
 * @brief draws all the Particles of this System
 *
 * The Cases in this Function all do the same:
 * Drawing all the particles with the appropriate Type.
 * This is just the fastest Way to do this, but will most likely be changed in the future.
 */
void SparkParticles::draw() const
{

  Particle* drawPart = particles;

  glDepthMask(GL_FALSE);
  glPushAttrib(GL_ENABLE_BIT);

  glDisable(GL_LIGHTING);
  glDisable(GL_TEXTURE_2D);

  glEnable(GL_LINE_SMOOTH);
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);

  glLineWidth(2.0);
  glBegin(GL_LINES);
  while (likely(drawPart != NULL))
  {
  //    printf("%f %f %f %f\n", drawPart->color[0], drawPart->color[1], drawPart->color[2], drawPart->color[3]);
    glColor4fv(drawPart->color);
    glVertex3f(drawPart->position.x, drawPart->position.y, drawPart->position.z);
    glVertex3f(drawPart->position.x - drawPart->velocity.x * drawPart->radius,
               drawPart->position.y - drawPart->velocity.y * drawPart->radius,
               drawPart->position.z - drawPart->velocity.z * drawPart->radius);
    drawPart = drawPart->next;
  }
  glEnd();

  glDepthMask(GL_TRUE);
  glPopAttrib();
}
