/**
 * @file graphics_effect.h
 *  abstract type of graphical effects
 */

#ifndef _GRAPHICS_EFFECT
#define _GRAPHICS_EFFECT

#include "base_object.h"

class TiXmlElement;

//! A class that handles GraphicsEffects. The GraphicsEffectManager operates on this.
class GraphicsEffect : public BaseObject
{
  public:
    GraphicsEffect(const TiXmlElement* root = NULL);
    virtual ~GraphicsEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate() = 0;
    virtual bool deactivate() = 0;

    virtual void draw() const;
    virtual void tick(float dt);

    inline bool isActivated() const { return this->bActivated; }


  protected:
    bool              bActivated;
};


#endif /* _GRAPHICS_EFFECT */
