/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "crosshair.h"
#include "event_handler.h"

#include "load_param.h"
#include "graphics_engine.h"
#include "glincl.h"
#include "state.h"
#include "material.h"

using namespace std;


/**
 * standart constructor
 */
Crosshair::Crosshair (const TiXmlElement* root)
{
  this->init();

  if (root)
    this->loadParams(root);
  else
    this->setTexture("maps/aim.png");
}

/**
 * destroys a Crosshair
*/
Crosshair::~Crosshair ()
{
  if (this->material)
  delete this->material;

  // delete what has to be deleted here

  GraphicsEngine::showMouse(true);
  GraphicsEngine::stealWMEvents(false);
}

/**
 * initializes the Crosshair
 */
void Crosshair::init()
{
  this->setClassID(CL_CROSSHAIR, "Crosshair");
  this->setName("Crosshair");

  this->setLayer(E2D_LAYER_TOP);
  this->setRotationSpeed(5);
  this->setSize(GraphicsEngine::getInstance()->getResolutionX()/10.0);

  this->setBindNode(this);
  this->material = new Material;

  //EventHandler::getInstance()->subscribe(this, ES_GAME, EV_MOUSE_MOTION);

  // center the mouse on the screen, and also hide the cursors
  SDL_WarpMouse(GraphicsEngine::getInstance()->getResolutionX()/2, GraphicsEngine::getInstance()->getResolutionY()/2);
  GraphicsEngine::showMouse(false);
  GraphicsEngine::stealWMEvents(true);
  SDL_WarpMouse(GraphicsEngine::getInstance()->getResolutionX()/2, GraphicsEngine::getInstance()->getResolutionY()/2);
}


void Crosshair::loadParams(const TiXmlElement* root)
{
  PNode::loadParams(root);
  EventListener::loadParams(root);

  LoadParam(root, "texture", this, Crosshair, setTexture)
      .describe("the texture-file to load onto the Crosshair");

  LoadParam(root, "size", this, Crosshair, setSize)
      .describe("the size of the Crosshair in Pixels");

  LoadParam(root, "rotation-speed", this, Crosshair, setRotationSpeed)
      .describe("the Speed with which the Crosshair should rotate");
}


/**
 * sets the size of the Crosshair.
 * @param size the size in pixels
 */
void Crosshair::setSize(float size)
{
  this->setSize2D(size/2, size/2);
}

/**
 * sets the material to load
 * @param textureFile The texture-file to load onto the crosshair
 */
void Crosshair::setTexture(const char* textureFile)
{
  this->material->setDiffuseMap(textureFile);
}

/**
 * processes the input
 * @param event the Event coming as input
 */
void Crosshair::process(const Event &event)
{
  if  (event.type == EV_MOUSE_MOTION)
  {
    //this->setAbsCoor2D(event.x, event.y);
  }
}

/**
 * ticks the Crosshair
 * @param dt the time to ticks
 */
void Crosshair::tick(float dt)
{
  // let the crosshair rotate
  this->shiftDir2D(dt * rotationSpeed);

/*
  float z = 0.0f;
  glReadPixels ((int)this->getAbsCoor2D().x,
                 GraphicsEngine::getInstance()->getResolutionY()-(int)this->getAbsCoor2D().y-1,
                 1,
                 1,
                 GL_DEPTH_COMPONENT,
                 GL_FLOAT,
                 &z);


  GLdouble objX=.0, objY=.0, objZ=.0;
  gluUnProject(this->getAbsCoor2D().x,
               GraphicsEngine::getInstance()->getResolutionY()-this->getAbsCoor2D().y-1,
               .99,  // z
               GraphicsEngine::modMat,
               GraphicsEngine::projMat,
               GraphicsEngine::viewPort,
               &objX,
               &objY,
               &objZ );*/

  //this->setAbsCoor(objX, objY, objZ);
}

/**
 * draws the crosshair
 */
void Crosshair::draw() const
{
  glPushMatrix();
  glTranslatef(this->getAbsCoor2D().x, this->getAbsCoor2D().y, 0);

  glRotatef(this->getAbsDir2D(), 0,0,1);
  this->material->select();
  glBegin(GL_TRIANGLE_STRIP);
  glTexCoord2f(0, 0);
  glVertex2f(-this->getSizeX2D(), -this->getSizeY2D());
  glTexCoord2f(1, 0);
  glVertex2f(this->getSizeX2D(), -this->getSizeY2D());
  glTexCoord2f(0, 1);
  glVertex2f(-this->getSizeX2D(), this->getSizeY2D());
  glTexCoord2f(1, 1);
  glVertex2f(this->getSizeX2D(), this->getSizeY2D());
  glEnd();
  glPopMatrix();
}
