
/*!
 * @file hover.h
 * Implements the Control of a Hover
 */

#ifndef _HOVER_H
#define _HOVER_H

#include "playable.h"

class Hover : public Playable
{
  public:

    Hover(const char* fileName);
    Hover(const TiXmlElement* root = NULL);
    virtual ~Hover();

    virtual void loadParams(const TiXmlElement* root);

    virtual void enter();
    virtual void leave();
    virtual void attachCamera();

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);

  private:
    void init();
    void movement(float time);

  private:
    bool                  bForward;           //!< forward button pressed.
    bool                  bBackward;          //!< backward button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    int                   yInvert;
    float                 mouseSensitivity;   //!< the mouse sensitivity
    int                   controlVelocityX;
    int                   controlVelocityY;
    //float                 cycle;              //!< hovercycle

    PNode                 wingNodeLeft;
    PNode                 wingNodeRight;
    PNode                 rotorNodeLeft;
    PNode                 rotorNodeRight;

    PNode                 cameraNode;

    Vector                velocity;           //!< the velocity of the Hover.
    Quaternion            direction;          //!< the direction of the Hover.
    float                 travelSpeed;        //!< the current speed of the Hove (to make soft movement)
    float                 acceleration;       //!< the acceleration of the Hover.
    //float                 rotorspeed;         //!< the speed of the rotor.
    //float                 tailrotorspeed;     //!< the relativ speed ot the tail rotor

    float                 airViscosity;

};

#endif /* _HOVERS_H */
