
/*!
 * @file helicopter.h
 * Implements the Control of a Helicopter
 */

#ifndef _HELICOPTER_H
#define _HELICOPTER_H

#include "playable.h"


class Helicopter : public Playable
{

  public:

    Helicopter();
    Helicopter(const char* fileName);
    Helicopter(const TiXmlElement* root);
    virtual ~Helicopter();

    virtual void loadParams(const TiXmlElement* root);

    virtual void enter();
    virtual void leave();
    virtual void attachCamera();

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);



  private:
    void init();
    void calculateVelocity(float time);

    // !! temporary !!
    void ADDWEAPON();

    bool                  bUp;                //!< up button pressed.
    bool                  bDown;              //!< down button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.
    bool                  bFire;              //!< fire button pressed.
    bool                  bRollL;             //!< rolling button pressed (left)
    bool                  bRollR;             //!< rolling button pressed (right)

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    int                   yInvert;
    float                 mouseSensitivity;   //!< the mouse sensitivity
    int                   controlVelocityX;
    int                   controlVelocityY;
    //float                 cycle;              //!< hovercycle

    PNode                 topRotor;
    PNode                 tailRotor;

    PNode                 cameraNode;

    Vector                velocity;           //!< the velocity of the player.
    Vector                velocityDir;        //!< the direction of the velocity of the spaceship
    float                 travelSpeed;        //!< the current speed of the player (to make soft movement)
    float                 acceleration;       //!< the acceleration of the player.
    //float                 rotorspeed;         //!< the speed of the rotor.
    //float                 tailrotorspeed;     //!< the relativ speed ot the tail rotor

    float                 airViscosity;

};

#endif /* _HELICOPTERS_H */
