

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Patrick Boenzli
   co-programmer:


   @todo: direction in which the projectile flights
   @todo: a target to set/hit
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "cannon.h"

#include "world_entity.h"
#include "model.h"
#include "world_entities/projectiles/projectile.h"
#include "weapon_manager.h"
#include "factory.h"

#include "vector.h"
#include "list.h"
#include "animation3d.h"

#include "fast_factory.h"


using namespace std;

CREATE_FACTORY(Cannon, CL_CANNON);

/**
 *  standard constructor

   creates a new weapon
*/
Cannon::Cannon ()
  : Weapon()
{
  this->init();
}


Cannon::Cannon(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
Cannon::~Cannon ()
{
  // model will be deleted from WorldEntity-destructor
}


void Cannon::init()
{
  this->setClassID(CL_CANNON, "Cannon");

//  this->model = (Model*)ResourceManager::getInstance()->load("models/guns/test_gun.obj", OBJ, RP_CAMPAIGN);

  this->loadModel("models/guns/plasmadriver_#.obj");

  this->setStateDuration(WS_SHOOTING, 2.0);
  this->setStateDuration(WS_RELOADING, .1);
  this->setStateDuration(WS_ACTIVATING, .1);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(100);
  this->increaseEnergy(100);
  //this->minCharge = 2;

  this->setActionSound(WA_SHOOT, "sound/explo.wav");
  this->setActionSound(WA_ACTIVATE, "sound/voices/cannon.wav");

  this->setCapability(WTYPE_ALLDIRS | WTYPE_DIRECTIONAL);
  this->setProjectileType(CL_BOMB);
  this->prepareProjectiles(5);

//  this->objectComponent1 = new PNode();
//  Animation3D* animation1 = this->getAnimation(WS_SHOOTING, this->objectComponent1);
  Animation3D* animation2 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation3 = this->getAnimation(WS_DEACTIVATING, this);
  //parent->addChild(this->objectComponent1, PNODE_ALL);
//  this->addChild(this->objectComponent1);

//  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);
  animation3->setInfinity(ANIM_INF_CONSTANT);

  this->setEmissionPoint(3.8, 1.2, 0);

//     animation1->addKeyFrame(Vector(0, -1.5, 0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_NULL);
//     animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.1, ANIM_LINEAR, ANIM_NULL);
//     animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.0, ANIM_LINEAR, ANIM_NULL);

  animation2->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation2->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);

  animation3->addKeyFrame(Vector(0.0, 0.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
  animation3->addKeyFrame(Vector(0.0, -1.0, 0.0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_NULL);
}


void Cannon::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}


/**
 *  this activates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void Cannon::activate()
{
}


/**
 *  this deactivates the weapon

   This is needed, since there can be more than one weapon on a ship. the
   activation can be connected with an animation. for example the weapon is
   been armed out.
*/
void Cannon::deactivate()
{
}


/**
 *  fires the weapon

   this is called from the player.cc, when fire-button is been pushed
   @todo: the ObjectManager deliveres Projectiles not TestBullets! this should be diffrent
*/
void Cannon::fire()
{
  Projectile* pj =  this->getProjectile();
  if (pj == NULL)
    return;

  pj->setParent(PNode::getNullParent());

  pj->setVelocity(this->getVelocity() + this->getAbsDir().apply(Vector(1,0,0))*15+VECTOR_RAND(5));

  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();
}

/**
 *  is called, when the weapon is destroyed
 *
 * this is in conjunction with the hit function, so when a weapon is able to get
 * hit, it can also be destoryed.
*/
void Cannon::destroy ()
{}

/**
 *  this will draw the weapon
*/
void Cannon::draw () const
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);

  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );

  this->getModel()->draw();
  glPopMatrix();

  /* draw objectComponent1: gun coil - animated stuff */
/*  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->objectComponent1->getAbsCoor ().x,
                this->objectComponent1->getAbsCoor ().y,
                this->objectComponent1->getAbsCoor ().z);
  tmpRot = this->objectComponent1->getAbsDir().getSpacialAxis();
  glRotatef (this->objectComponent1->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  this->model->draw(0);

  glPopMatrix();*/
}

