/*!
 * @file billboard.h
 *  Definition of a billboard
 */

#ifndef _IMAGE_ENTITY_H
#define _IMAGE_ENTITY_H

#include "p_node.h"
#include "element_2d.h"
#include "event_listener.h"

#include "vector.h"


// FORWARD DECLARATION
class Model;
class Material;
class TiXmlElement;

//! A class that enables the
class Billboard : public PNode, public Element2D {

  public:
    Billboard(const TiXmlElement* root = NULL);
    virtual ~Billboard();

    void init();
    void loadParams(const TiXmlElement* root);

    void setSize(float sizeX, float sizeY);
    void setTexture(const char* textureFile);
    /** @param rotationSpeed the speed at what the crosshair should rotate */
    void setRotationSpeed(float rotationSpeed) { this->rotationSpeed = rotationSpeed; };
    void toggleBillboard();

    virtual void tick(float dt);
    virtual void draw() const;

  private:
    Material*        material;             //!< a material for the Aim.
    float            rotationSpeed;        //!< Speed of the Rotation.
    bool             bBillboarding;        //!< true if billboarding is on
};

#endif /* _IMAGE_ENTITY_H */
