/**
 * @file lense_flare.h
 *  lense flare effect
 */

#ifndef _LENSE_FLARE
#define _LENSE_FLARE

#include "graphics_effect.h"

#include <vector>


class TiXmlElement;
class Light;
class Element2D;

//! A class that handles LenseFlares. The LenseFlareManager operates on this.
class LenseFlare : public GraphicsEffect
{
  public:
    LenseFlare(const TiXmlElement* root = NULL);
    virtual ~LenseFlare();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate();
    virtual bool deactivate();

    virtual void draw() const;

    void addFlare(const char* textureName);


  private:
    GLint charToFogMode(const char* mode);


  private:
    Light*                   lightSource;        //!< reference to the sun (or primary light source)
    std::vector<Element2D*>  flares;             //!< the flares array
};


#endif /* _LENSE_FLARE */
