

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "lense_flare.h"

#include "load_param.h"
#include "factory.h"

#include "glincl.h"
#include "texture.h"


using namespace std;

CREATE_FACTORY(LenseFlare, CL_LENSE_FLARE);



/**
 *  default constructor
 * @param root The XML-element to load the LenseFlare from
 */
 LenseFlare::LenseFlare(const TiXmlElement* root)
{

  if (root != NULL)
    this->loadParams(root);
}


/**
 *  destroys a LenseFlare
 */
LenseFlare::~LenseFlare()
{}


/**
 * @param root The XML-element to load the LenseFlare from
 */
void LenseFlare::loadParams(const TiXmlElement* root)
{
  GraphicsEffect::loadParams(root);

    LoadParam(root, "add-flare-texture", this, LenseFlare, addFlare)
        .describe("adds a lensflare texture to the engine");

}


/**
 * initializes the fog effect
 */
bool LenseFlare::init()
{

}


/**
 * activates the fog effect
 */
bool LenseFlare::activate()
{

}


/**
 * deactivates the fog effect
 */
bool LenseFlare::deactivate()
{

}


/**
 * converts a gl mode char to a GLint
 * @param mode the mode character
 */
GLint LenseFlare::charToFogMode(const char* mode)
{}


/**
 * adds a texture flare
 * @param textureName the name of the flare texture
 */
void addFlare(const char* textureName)
{
  Texture* texture = new Texture (textureName, GL_TEXTURE);


}


