/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: David Gruetter
   co-programmer: Benjamin Grauer

   Created by Dave: this file is actually quite similar to player.cc and so is
   skybox.h similar to player.h
   With that said, things should be clear:)

   Edited:
   Bensch: more constructors, changeability, comments...
   Patrick: giving it the common orxonox style, not much to do... good work Dave!

*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "skysphere.h"
#include "stdincl.h"

#include "material.h"
#include "debug.h"


using namespace std;

/**
 *  Constructs a SkySphere and takes fileName as a map.
 * @param fileName the file to take as input for the skysphere
*/
Skysphere::Skysphere(char* fileName)
{
  this->setClassID(CL_SKYSPHERE, "SkySphere");
  this->toList(OM_ENVIRON_NOTICK);
  if (fileName == NULL)
    this->initialize("pictures/sky-replace.jpg");
  else
    this->initialize(fileName);
}


/**
 *  default destructor
*/
Skysphere::~Skysphere()
{
  PRINTF(3)("Deleting the SkySphere\n");
  delete this->skyMaterial;
  gluDeleteQuadric(this->sphereObj);
}

/**
 *  initializes the Skysphere.
 * @param fileName the file to take as input for the skysphere
*/
void Skysphere::initialize(char* fileName)
{
  PRINTF(1)("initializing the Skysphere with Material %s.\n", fileName);
  this->sphereObj = gluNewQuadric();
  this->setParentMode(PNODE_MOVEMENT);

  gluQuadricTexture(this->sphereObj, GL_TRUE);
  this->setRadius(1900.0);

  this->skyMaterial = new Material("Sky");
  this->setTexture(fileName);
  this->skyMaterial->setIllum(3);
  this->skyMaterial->setAmbient(1.0, 1.0, 1.0);
}


/**
 *  Defines which texture should be loaded onto the skysphere.
 * @param fileName The filename of the Texture
*/
void Skysphere::setTexture(char* fileName)
{
  this->skyMaterial->setDiffuseMap(fileName);
}


/**
 *  draws the Skysphere

   This part is normally precessed in the "Painting Phase".
*/
void Skysphere::draw() const
{
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  Vector r = this->getAbsCoor();
  glTranslatef(r.x, r.y, r.z);

  //glRotatef(-30, 1, 0, 0);
  //glRotatef(95.0f, 0.0f, 0.0f, 1.0f);
  //glRotatef(-250.0f, 0.0, 1.0f, 0.0f);

  skyMaterial->select();
  gluSphere(this->sphereObj, this->sphereRadius, 20, 20);
  glPopMatrix();
}


/**
 *  sets the Radius of the Sphere.
 * @param radius The Radius of The Sphere
*/
void Skysphere::setRadius(float radius)
{
  this->sphereRadius = radius;
}
