

/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

### File Specific:
   main-programmer: Patrick Boenzli
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_GRAPHICS

#include "fog_effect.h"

#include "load_param.h"
#include "factory.h"

#include "glincl.h"



using namespace std;

CREATE_FACTORY(FogEffect, CL_FOG_EFFECT);



/**
 *  default constructor
 * @param root The XML-element to load the FogEffect from
 */
 FogEffect::FogEffect(const TiXmlElement* root)
{

  this->fogMode = GL_EXP2;
  this->fogDensity = 0.001f;
  this->fogStart = 10.0f;
  this->fogEnd = 1000.0f;


  if (root != NULL)
    this->loadParams(root);
}


/**
 *  destroys a FogEffect
 */
FogEffect::~FogEffect()
{}


/**
 * @param root The XML-element to load the FogEffect from
 */
void FogEffect::loadParams(const TiXmlElement* root)
{
  GraphicsEffect::loadParams(root);

   LoadParam(root, "fog-effect", this, FogEffect, setFogMode)
       .describe("sets the the fog mode {GL_LINEAR, GL_EXP, GL_EXP2}");

   LoadParam(root, "fog-density", this, FogEffect, setFogDensity)
       .describe("sets the the fog density of the exponentionl functions");

   LoadParam(root, "fog-range", this, FogEffect, setFogRange)
       .describe("sets the the range of the linear functions");
}


/**
 * initializes the fog effect
 */
bool FogEffect::init()
{}


/**
 * activates the fog effect
 */
bool FogEffect::activate()
{
  PRINTF(4)( "Enabling Fog Effect, mode: %i, density: %f, start: %f, end: %f\n", this->fogMode, this->fogDensity,
             this->fogStart, this->fogEnd);

  glEnable(GL_FOG);
  {
    GLfloat fogColor[4] = {0.5, 0.5, 0.5, 1.0};

    glFogi(GL_FOG_MODE, this->fogMode);
    glFogfv(GL_FOG_COLOR, fogColor);
    glFogf(GL_FOG_DENSITY, this->fogDensity);
    glHint(GL_FOG_HINT, GL_DONT_CARE);
    glFogf(GL_FOG_START, this->fogStart);
    glFogf(GL_FOG_END, this->fogEnd);

    //glFogi(GL_FOG_COORDINATE_SOURCE, GL_FOG_COORDINATE);
  }
  glClearColor(0.5, 0.5, 0.5, 1.0);
}


/**
 * deactivates the fog effect
 */
bool FogEffect::deactivate()
{
  glDisable(GL_FOG);
}


/**
 * converts a gl mode char to a GLint
 * @param mode the mode character
 */
GLint FogEffect::charToFogMode(const char* mode)
{
  if( !strcmp( "GL_LINEAR", mode))
    return GL_LINEAR;
  else if( !strcmp("GL_EXP", mode))
    return GL_EXP;
  else if(!strcmp("GL_EXP2", mode) )
    return GL_EXP2;
  else
    return -1;
}

