/**
 * @file fog_effect.h
 *  atmospheric fog
 */

#ifndef _FOG_EFFECT
#define _FOG_EFFECT

#include "graphics_effect.h"

class TiXmlElement;

//! A class that handles FogEffects. The FogEffectManager operates on this.
class FogEffect : public GraphicsEffect
{
  public:
    FogEffect(const TiXmlElement* root = NULL);
    virtual ~FogEffect();

    virtual void loadParams(const TiXmlElement* root);

    virtual bool init();

    virtual bool activate();
    virtual bool deactivate();

    void setFogMode(const char* mode) { this->fogMode = this->charToFogMode(mode); }
    void setFogDensity(float density) { this->fogDensity = density; }
    void setFogRange(float start, float end) { this->fogStart = start; this->fogEnd = end; }


  private:
    GLint charToFogMode(const char* mode);


  private:
    GLint                   fogMode;
    GLfloat                 fogDensity;
    GLfloat                 fogStart;
    GLfloat                 fogEnd;
};


#endif /* _FOG_EFFECT */
