/*!
 * @file water.h
 *  Definition of the SkyBox, that handles the Display of an atmosphere for orxonox.
 *
 * A SkyBox is always centered at the current working Camera, and will only obey the cameras
 * movment but not its rotation.
*/

#ifndef _WATER_H
#define _WATER_H

/* INCLUDES */
#include "world_entity.h"

/* FORWARD DECLARATION */
class Material;
class Grid;
class Shader;

//! A Class to handle a WaterEffects
class Water : public WorldEntity
{
 public:
   Water(const TiXmlElement* root = NULL);
   ~Water();

   void loadParams(const TiXmlElement* root);

   void setResolution(unsigned int resX, unsigned int resY);
   void setSize(float sizeX, float sizeY);
   void setHeight(float height);
   void rebuildGrid();

   void wave(float x, float y, float z, float force);
   inline void wave(Vector pos, float force) { this->wave(pos.x, pos.y, pos.z, force); };

   void draw() const;
   void tick(float dt);

   virtual int writeBytes(const byte* data, int length, int sender);
   virtual int readBytes(byte* data, int maxLength, int * reciever);

   int writeState( const byte * data, int length, int sender );
   int readState( byte * data, int maxLength );

  private:
    bool posToGridPoint(float x, float z, unsigned int& row, unsigned int& column);

  private:
    Grid*           grid;            //!< The water-surface-model to render with
    float**         velocities;      //!< Velocities.
    float           viscosity;       //!< Viscosity (bigger more like honey, smaller more like water).
    float           cohesion;        //!< Cohesion.

    Material*       waterMaterial;
    Shader*         waterShader;
    float           height;          //!< The hight of the Water

    unsigned int    resX, resY;
    float           sizeX, sizeY;

    float phase;
};

#endif  /* _WATER_H */



