/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Benjamin Grauer
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "turret.h"

#include "weapon_manager.h"
#include "world_entities/projectiles/projectile.h"

#include "model.h"

#include "state.h"
#include "animation3d.h"

#include "factory.h"

CREATE_FACTORY(Turret, CL_TURRET);

using namespace std;

/**
 *  standard constructor
 *
 * creates a new Turret
 */
Turret::Turret ()
  : Weapon()
{
  this->init();

  this->setActionSound(WA_SHOOT, "sound/shot1.wav");
  this->setActionSound(WA_ACTIVATE, "sound/vocals/missiles.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");

}

/**
 * creates a new Turret from a TiXmlElement
 */
Turret::Turret(const TiXmlElement* root)
{
  this->init();
  if (root != NULL)
    this->loadParams(root);
}

/**
 *  standard deconstructor
*/
Turret::~Turret ()
{
  // model will be deleted from WorldEntity-destructor
}

void Turret::init()
{
  this->setClassID(CL_TURRET, "Turret");


  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .1);
  this->setStateDuration(WS_RELOADING, 1.0f);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(100);
  this->increaseEnergy(100);
  //this->minCharge = 2;

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET);
  this->setProjectileType(CL_ROCKET);

  this->loadModel("models/guns/turret1.obj");

  this->setEmissionPoint(1.684, 0.472, 0);
  //this->getProjectileFactory()->prepare(100);
  this->loadModel("models/guns/turret1.obj");

}

void Turret::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);
}

void Turret::activate()
{
}

void Turret::deactivate()
{
}

void Turret::tick(float dt)
{
  if (!Weapon::tickW(dt))
    return;

  Quaternion quat;
  Vector direction = this->getAbsCoor();/*this->getWeaponManager()->getFixedTarget()->getAbsCoor() - this->getAbsCoor();*/

  direction.normalize();

  if (likely (this->getParent() != NULL))
    quat = Quaternion(direction, this->getParent()->getAbsDir().apply(Vector(0,1,0))) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;
  else
    quat = Quaternion(direction, Vector(0,1,0)) * Quaternion ( -M_PI_2, Vector(0,1,0)) ;

  this->setAbsDirSoft(quat, 5);
}

void Turret::fire()
{
  Projectile* pj = this->getProjectile();
  if (pj == NULL)
    return;

  pj->setVelocity(this->getVelocity()+(this->getAbsDir().apply(Vector(1,0,0))*100.0 /*+ VECTOR_RAND(13) */
            /*target->getAbsCoor() - this->getAbsCoor()*/)*.5);//this->getVelocity());


  pj->setParent(PNode::getNullParent());
  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();
}

void Turret::destroy ()
{}
