/*!
 * @file movie_entity.h
 *  Definition of a Movie Screen
 */

#ifndef _MOVIE_ENTITY_H
#define _MOVIE_ENTITY_H

#include "world_entity.h"


class MediaContainer;

class MovieEntity : public WorldEntity
{
  private:
    MediaContainer* media_container;

    int counter;
    float timer;
    float fps;

    float axis;
    float rotation;
    float height;
    float width;

    bool mediaLoaded;

  public:
    MovieEntity (const TiXmlElement* root = NULL);
    ~MovieEntity ();

    virtual void draw () const;
    virtual void tick (float time);

    virtual void loadParams(const TiXmlElement* root);

    void loadMovie(const char* filename);
    void setAxis(float axis);
    void setRotation(float rotation);
    void setSize(float width, float height);

};

#endif /* _MOVIE_ENTITY_H */
