/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: David Hasenfratz, Stefan Lienhard
   co-programmer:
*/

#include "movie_loader.h"

#include "movie_player.h"
#include "factory.h"
#include "graphics_engine.h"
#include "load_param.h"
#include "state.h"


using namespace std;

CREATE_FACTORY(MovieLoader, CL_MOVIE_LOADER);

MovieLoader::MovieLoader(const TiXmlElement* root)
{
  this->setClassID(CL_MOVIE_LOADER, "MovieLoader");

  movie_player = new MoviePlayer();
  this->loadParams(root);
}

MovieLoader::~MovieLoader() 
{
  delete this->movie_player;
}



void MovieLoader::loadParams(const TiXmlElement* root)
{
  StoryEntity::loadParams(root);

  LoadParam(root, "name", this, MovieLoader, loadMovie);
}

void MovieLoader::loadMovie(const char* filename)
{
  movie_player->loadMovie(filename);
}


ErrorMessage MovieLoader::init() {}


ErrorMessage MovieLoader::loadData() {}


ErrorMessage MovieLoader::unloadData() {}

bool MovieLoader::start()
{
  this->movie_player->start(0);
  
  this->isRunning = true;
  this->run();
}

bool MovieLoader::stop()
{
  this->isRunning = false;
}

bool MovieLoader::pause() { }
bool MovieLoader::resume() { }

void MovieLoader::run()
{
  // first timestamp for t = 0
  this->lastFrame = SDL_GetTicks ();

  while( this->isRunning)
  {
    this->tick();
    this->draw();
  }
}

void MovieLoader::draw() const
{
  glClear( GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);


  GraphicsEngine::enter2DMode();

  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, movie_player->getTexture());

  glColor3f(1.0, 1.0, 1.0);

  glBegin(GL_QUADS);
    glTexCoord2f(0.0f, 0.0f); glVertex2f( 0, 0);
    glTexCoord2f(0.0f, 1.0f); glVertex2f( 0, State::getResY());
    glTexCoord2f(1.0f, 1.0f); glVertex2f( State::getResX(), State::getResY());
    glTexCoord2f(1.0f, 0.0f); glVertex2f( State::getResX(), 0);
  glEnd();

  GraphicsEngine::leave2DMode();

  SDL_GL_SwapBuffers();
}


void MovieLoader::tick()
{
  // get timestamp
  currentFrame = SDL_GetTicks();

  // calculate time difference in milliseconds (Uint32)
  this->dt = currentFrame - this->lastFrame; 
  // calculate time difference in seconds (float)
  this->dts = (float)this->dt / 1000.0f;

  movie_player->tick(dts);

  if (movie_player->getStatus() == STOP)
    this->isRunning = false;

  this->lastFrame = currentFrame;
}
