/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific
   main-programmer: Benjamin Grauer
   co-programmer:
*/
#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WEAPON

#include "targeting_turret.h"

#include "weapon_manager.h"
#include "aim.h"
#include "world_entities/projectiles/projectile.h"

#include "model.h"

#include "animation3d.h"

#include "factory.h"

CREATE_FACTORY(TargetingTurret, CL_TARGETING_TURRET);

using namespace std;


/**
 *  standard constructor

   creates a new weapon
*/
TargetingTurret::TargetingTurret ()
  : Weapon()
{
  this->init();

}


TargetingTurret::TargetingTurret(const TiXmlElement* root)
{
  this->init();
  this->loadParams(root);
}

/**
 *  standard deconstructor
*/
TargetingTurret::~TargetingTurret ()
{
  // model will be deleted from WorldEntity-destructor
//  delete this->target;
}

void TargetingTurret::init()
{
  this->setClassID(CL_TARGETING_TURRET, "TargetingTurret");

  Animation3D* animation1 = this->getAnimation(WS_ACTIVATING, this);
  Animation3D* animation2 = this->getAnimation(WS_DEACTIVATING, this);

  animation1->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation1->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, 0, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);
  animation2->addKeyFrame(Vector(0, -.5, 0), Quaternion(), 0.3, ANIM_LINEAR, ANIM_CONSTANT);

  animation1->setInfinity(ANIM_INF_CONSTANT);
  animation2->setInfinity(ANIM_INF_CONSTANT);

  this->setStateDuration(WS_SHOOTING, .1);
  this->setStateDuration(WS_RELOADING, .1);
  this->setStateDuration(WS_ACTIVATING, .4);
  this->setStateDuration(WS_DEACTIVATING, .4);

  this->setEnergyMax(10000);
  this->increaseEnergy(100000);

  this->setCapability(WTYPE_ALLDIRS | WTYPE_TURRET);
  this->setProjectileType(CL_GUIDED_MISSILE);


  this->setEmissionPoint(1.684, 0.472, 0);
  //this->getProjectileFactory()->prepare(100);

  this->target = new Aim(this);
  this->target->setVisibility(false);
  this->target->setRange(100);
  this->target->setAngle(M_PI_4/16);
  this->lockedTime = 0;
  this->neededLockTime = 2;
  this->lockedTarget->setParent(PNode::getNullParent());
  this->loadModel("models/guns/turret2.obj");


  this->setActionSound(WA_SHOOT, "sound/shot1.wav");
  this->setActionSound(WA_ACTIVATE, "sound/voices/rockets.wav");
  this->setActionSound(WA_RELOAD, "sound/vocals/reload.wav");
}

void TargetingTurret::loadParams(const TiXmlElement* root)
{
  Weapon::loadParams(root);

}

void TargetingTurret::activate()
{
  this->target->setVisibility(true);
}

void TargetingTurret::deactivate()
{
  this->target->setVisibility(false);
}

void TargetingTurret::tick(float dt)
{
  if( lockedTime >= neededLockTime )
   {
    lockedTarget = this->target->getParent();
    lockedTime = 0;
   }

  this->target->tick(dt);

  if(this->target->getParent() == PNode::getNullParent())
   lockedTime = 0;
  else
   lockedTime += dt;

}

void TargetingTurret::fire()
{
  Projectile* pj = this->getProjectile();
  if (pj == NULL)
    return;

  pj->setVelocity(this->getVelocity() + /*this->getVelocity()+*/(this->getAbsDir().apply(Vector(1,0,0))*250.0 + VECTOR_RAND(13)
            /*target->getAbsCoor() - this->getAbsCoor()*/)*.5);//this->getVelocity());

  pj->setTarget(lockedTarget);
  pj->setParent(PNode::getNullParent());
  pj->setAbsCoor(this->getEmissionPoint());
  pj->setAbsDir(this->getAbsDir());
  pj->activate();
  
}

void TargetingTurret::destroy ()
{}

/**
 * draws the TargetingTurret
*/
void TargetingTurret::draw () const
{
  /* draw gun body */
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);
  Vector tmpRot = this->getAbsDir().getSpacialAxis();
  glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
  if (this->getModel() != NULL)
    this->getModel()->draw();
  glPopMatrix();
}

