/*!
 * @file weapon_power_up.h
 * @brief A class representing a PowerUp containing a weapon.
*/

#ifndef _WEAPON_POWER_UP_H
#define _WEAPON_POWER_UP_H

#include "power_up.h"
#include "weapons/weapon.h"

/* FORWARD DEFINITION */

class WeaponPowerUp : public PowerUp {

public:
  WeaponPowerUp();
  WeaponPowerUp(const TiXmlElement* root);
  virtual ~WeaponPowerUp ();

  virtual void loadParams(const TiXmlElement* root);

  Weapon* getWeapon();
  void setWeaponClass(const char* name);

  virtual int writeBytes(const byte* data, int length, int sender);
  virtual int readBytes(byte* data, int maxLength, int * reciever );

protected:
  virtual void respawn();

private:
  void init();
private:
  Weapon* weapon;
  ClassID weaponID;
  const TiXmlElement* weaponXML;

  void createWeapon();
};

#endif /* _WEAPON_POWER_UP_H */
