/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Manuel Leuenberger
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY


#include "power_up.h"
#include "extendable.h"
#include "primitive_model.h"

using namespace std;

PowerUp::PowerUp(float r, float g, float b)
{
  this->setClassID(CL_POWER_UP, "PowerUp");

  this->respawnType = RESPAWN_NONE;
  this->respawnStart = 10;
  this->model = NULL;
/*  if(!PowerUp::sphereModel) {*/

  Model* sphereModel = new PrimitiveModel(PRIM_SPHERE, 7, 5);

  this->setModel(sphereModel);
  this->buildObbTree( 4);
  this->sphereMaterial = new Material;
  this->sphereMaterial->setTransparency(.1);
  this->sphereMaterial->setDiffuse(r, g, b);
  this->toList(OM_COMMON);
}

PowerUp::~PowerUp ()
{
  delete this->sphereMaterial;
}


void PowerUp::loadParams(const TiXmlElement* root)
{
  WorldEntity::loadParams(root);
}


void PowerUp::collidesWith (WorldEntity* entity, const Vector& location)
{
  if(entity->isA(CL_EXTENDABLE))
  {
    if(dynamic_cast<Extendable*>(entity)->pickup(this))
    {
      this->respawnTime = this->respawnStart;
      this->toList(OM_DEAD_TICK);
    }
  }
}

void PowerUp::tick(float dt) {
  if(this->getOMListNumber() != OM_COMMON) {
    this->respawnTime -= dt;
    if(this->respawnTime <= 0) {
      this->respawn();
      this->toList(OM_COMMON);
    }
  }
}

void PowerUp::draw() const
{
  if(this->model != NULL) {
    glMatrixMode(GL_MODELVIEW);
    glPushMatrix();
    glTranslatef (this->getAbsCoor ().x,
                  this->getAbsCoor ().y,
                  this->getAbsCoor ().z);
    Vector tmpRot = this->getAbsDir().getSpacialAxis();
    glRotatef (this->getAbsDir().getSpacialAxisAngle(), tmpRot.x, tmpRot.y, tmpRot.z );
    this->model->draw();
    glPopMatrix();
  }
  this->sphereMaterial->select();
  WorldEntity::draw();
}

const char* PowerUp::respawnTypes[] = {
  "none",
  "time"
};

void PowerUp::setRespawnType(const char* type)
{
  for(int i = 0; i < RESPAWN_size; ++i) {
    if(!strcmp(type, respawnTypes[i])) {
      this->respawnType = (PowerUpRespawn)i;
      break;
    }
  }
}



/********************************************************************************************
 NETWORK STUFF
 ********************************************************************************************/


/**
 * data copied in data will bee sent to another host
 * @param data pointer to data
 * @param maxLength max length of data
 * @return the number of bytes writen
 */
int PowerUp::readState( byte * data, int maxLength )
{
  SYNCHELP_WRITE_BEGIN();
  SYNCHELP_WRITE_FKT( WorldEntity::readState );
  return SYNCHELP_WRITE_N;
}


/**
 * Writes data from network containing information about the state
 * @param data pointer to data
 * @param length length of data
 * @param sender hostID of sender
 */
int PowerUp::writeState( const byte * data, int length, int sender )
{
  SYNCHELP_READ_BEGIN();
  SYNCHELP_READ_FKT( WorldEntity::writeState );
  return SYNCHELP_READ_N;
}

