/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "weapon_power_up.h"
#include "factory.h"
#include "state.h"
#include "list.h"
#include "network_game_manager.h"

#include "primitive_model.h"

#include "factory.h"
#include "load_param.h"

using namespace std;

CREATE_FACTORY(WeaponPowerUp, CL_WEAPON_POWER_UP);

WeaponPowerUp::WeaponPowerUp () : PowerUp(1.0, 1.0, 0.0)
{
  this->init();
}

WeaponPowerUp::WeaponPowerUp(const TiXmlElement* root) : PowerUp(1.0, 1.0, 0.0)
{
  this->init();
  if( root != NULL)
    this->loadParams(root);
}


WeaponPowerUp::~WeaponPowerUp ()
{
}


void WeaponPowerUp::init()
{
  this->setClassID(CL_WEAPON_POWER_UP, "WeaponPowerUp");
  this->weaponXML = NULL;
  this->weapon = NULL;
}


void WeaponPowerUp::loadParams(const TiXmlElement* root)
{
  PowerUp::loadParams(root);
  const TiXmlElement* elem = root->FirstChildElement("weapon");
  if(elem != NULL && (elem = elem->FirstChildElement()) != NULL)
  {
    this->weaponXML = elem;
    respawn();
  }
  else
  {
    LoadParam(root, "weaponID", this, WeaponPowerUp, setWeaponClass);
  }
  this->model = this->weapon->getModel(0);
}

Weapon* WeaponPowerUp::getWeapon()
{
  return this->weapon;
}

void WeaponPowerUp::respawn()
{
  this->weapon = dynamic_cast<Weapon*>((weaponXML == NULL)
      ? Factory::fabricate(static_cast<ClassID>(this->weapon->getClassID()))
      : Factory::fabricate(weaponXML));
}

void WeaponPowerUp::setWeaponClass(const char* name)
{
  this->weapon = dynamic_cast<Weapon*>(Factory::fabricate(name));
}

int WeaponPowerUp::writeBytes( const byte * data, int length, int sender )
{
  setRequestedSync( false );
  setIsOutOfSync( false );

  SYNCHELP_READ_BEGIN();

  SYNCHELP_READ_FKT( PowerUp::writeState );

  //TODO: sync weapon class ( see loadParams )

  return SYNCHELP_READ_N;
}



int WeaponPowerUp::readBytes( byte * data, int maxLength, int * reciever )
{
  if ( isOutOfSync() && !requestedSync() && this->getHostID()!=this->getOwner() )
  {
    (NetworkGameManager::getInstance())->sync( this->getUniqueID(), this->getOwner() );
    setRequestedSync( true );
  }

  int rec = this->getRequestSync();
  if ( rec > 0 )
  {
    *reciever = rec;

    SYNCHELP_WRITE_BEGIN();

    SYNCHELP_WRITE_FKT( PowerUp::readState );

    //TODO: sync weapon class ( see loadParams )

    return SYNCHELP_WRITE_N;
  }

  *reciever = 0;
  return 0;
}
