/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "param_power_up.h"
#include "factory.h"
#include "state.h"
#include "list.h"

#include "primitive_model.h"

#include "factory.h"
#include "load_param.h"
#include "network_game_manager.h"

using namespace std;

CREATE_FACTORY(ParamPowerUp, CL_PARAM_POWER_UP);

const char* ParamPowerUp::paramTypes[] = {
  "shield",
  "max-shield",
  "health",
  "max-health",
};

ParamPowerUp::ParamPowerUp () : PowerUp(0.0, 1.0, 0.0)
{
  this->init();
}

ParamPowerUp::ParamPowerUp(const TiXmlElement* root) : PowerUp(0.0, 1.0, 0.0)
{
  this->init();
  if( root != NULL)
    this->loadParams(root);
}


ParamPowerUp::~ParamPowerUp ()
{
}


void ParamPowerUp::init()
{
  this->setClassID(CL_PARAM_POWER_UP, "ParamPowerUp");
  this->value = 0;
  this->max_value = 0;
  this->min_value = 0;
}


void ParamPowerUp::loadParams(const TiXmlElement* root)
{
  PowerUp::loadParams(root);
  LoadParam(root, "type", this, ParamPowerUp, setType);

  if( root != NULL && root->FirstChildElement("value") != NULL) {

    LoadParam(root, "value", this, ParamPowerUp, setValue);
  }
  else {
    LoadParam(root, "max-value", this, ParamPowerUp, setMaxValue);
    LoadParam(root, "min-value", this, ParamPowerUp, setMinValue);
    respawn();
  }
}

void ParamPowerUp::setValue(float value)
{
  this->value = value;
}

void ParamPowerUp::setType(const char* type)
{
  for(int i = 0; i < POWERUP_PARAM_size; ++i) {
    if(strcmp(type, paramTypes[i]) == 0) {
      this->type = (EnumParamPowerUpType)i;
      break;
    }
  }
}

void ParamPowerUp::setMaxValue(float value)
{
  this->max_value = value;
}

void ParamPowerUp::setMinValue(float value)
{
  this->min_value = value;
}

float ParamPowerUp::getValue()
{
  return this->value;
}

EnumParamPowerUpType ParamPowerUp::getType()
{
  return this->type;
}

void ParamPowerUp::respawn()
{
  if(this->min_value != this->max_value)
  {
    this->value = this->min_value + rand() * (this->max_value - this->min_value);
  }
}

int ParamPowerUp::writeBytes( const byte * data, int length, int sender )
{
  setRequestedSync( false );
  setIsOutOfSync( false );

  SYNCHELP_READ_BEGIN();

  SYNCHELP_READ_FKT( PowerUp::writeState );

  int i;
  SYNCHELP_READ_INT( i );
  this->type = (EnumParamPowerUpType)i;
  SYNCHELP_READ_FLOAT( this->value );

  if ( this->value != 0 )
  {
    SYNCHELP_READ_FLOAT( this->min_value );
    SYNCHELP_READ_FLOAT( this->max_value );
    respawn();
  }

  return SYNCHELP_READ_N;
}



int ParamPowerUp::readBytes( byte * data, int maxLength, int * reciever )
{
  if ( isOutOfSync() && !requestedSync() && this->getHostID()!=this->getOwner() )
  {
    (NetworkGameManager::getInstance())->sync( this->getUniqueID(), this->getOwner() );
    setRequestedSync( true );
  }

  int rec = this->getRequestSync();
  if ( rec > 0 )
  {
    *reciever = rec;

    SYNCHELP_WRITE_BEGIN();

    SYNCHELP_WRITE_FKT( PowerUp::readState );

    int i = (int)this->type;
    SYNCHELP_WRITE_INT( i );
    SYNCHELP_WRITE_FLOAT( this->value );

    if ( this->value != 0 )
    {
      SYNCHELP_WRITE_FLOAT( this->min_value );
      SYNCHELP_WRITE_FLOAT( this->max_value );
    }

    return SYNCHELP_WRITE_N;
  }

  *reciever = 0;
  return 0;
}

