/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/

#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_WORLD_ENTITY

#include "planet.h"

#include "load_param.h"
#include "factory.h"
#include "static_model.h"

#include "material.h"
#include "texture.h"

#include "network_game_manager.h"
#include "converter.h"
#include "vertex_array_model.h"
#include "primitive_model.h"

using namespace std;


CREATE_FACTORY(Planet, CL_PLANET);



/**
 *  initializes a skybox from a XmlElement
*/
Planet::Planet(const TiXmlElement* root)
{
  this->setClassID(CL_PLANET, "Planet");
  this->toList(OM_GROUP_01);

  this->material = new Material();
  //this->material->setIllum(20);
  //this->material->setAmbient(0.1, 0.1, 0.1);



      //st float radius, const unsigned int loops, const unsigned int segmentsPerLoop

  this->loadParams(root);

//   VertexArrayModel* model = new VertexArrayModel();
//   model->spiralSphere(this->size, 10, 10);
//   this->setModel(model);
//   model->debug();
//
  PrimitiveModel* model = new PrimitiveModel(PRIM_SPHERE, this->size, 50);
  this->setModel(model);
}


/**
 *  default destructor
*/
Planet::~Planet()
{
  PRINTF(5)("Deleting Planet\n");
  if( this->material)
    delete this->material;
}


void Planet::loadParams(const TiXmlElement* root)
{
  static_cast<WorldEntity*>(this)->loadParams(root);

  LoadParam(root, "texture", this, Planet, setTexture)
      .describe("Sets the material on the Planet. The string must be the path relative to the data-dir, and without a trailing .jpg");

  LoadParam(root, "size", this, Planet, setSize)
      .describe("Sets the Size of the Planet (normally this should be 90% of the maximal viewing Distance).");
}


/**
 *  Defines which textures should be loaded onto the Planet.
 * @param textureName the top texture.
*/
void Planet::setTexture(const char* textureName)
{
  this->material->setDiffuseMap(textureName);
}


/**
 * @param size The new size of the Planet

 * do not forget to rebuild the Planet after this.
*/
void Planet::setSize(float size)
{
  this->size = size;
}



void Planet::draw() const
{


  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  glShadeModel(GL_SMOOTH);

  /* translate */
  glTranslatef (this->getAbsCoor ().x,
                this->getAbsCoor ().y,
                this->getAbsCoor ().z);


  this->material->select();

//   /WorldEntity::draw();
  this->getModel(0)->draw();
 // static_cast<VertexArrayModel*>(this->getModel(0))->debug();
}



