/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Patrick Boenzli
   co-programmer: ...
*/


/* this is for debug output. It just says, that all calls to PRINT() belong to the DEBUG_MODULE_NETWORK module
   For more information refere to https://www.orxonox.net/cgi-bin/trac.cgi/wiki/DebugOutput
*/
#define DEBUG_MODULE_NETWORK

#include "class_list.h"
#include "debug.h"
#include "shell_command.h"

/* include your own header */
#include "network_manager.h"
#include "shared_network_data.h"
#include "network_stream.h"


/* using namespace std is default, this needs to be here */
using namespace std;

SHELL_COMMAND(debug, NetworkManager, debug);


NetworkManager* NetworkManager::singletonRef = NULL;

/**
 *  standard constructor
 */
NetworkManager::NetworkManager()
{
  /* set the class id for the base object */
  this->setClassID(CL_NETWORK_MANAGER, "NetworkManager");
  PRINTF(0)("START\n");

  /* initialize the references */
  this->netStreamList = NULL;
  this->syncList = NULL;
  this->defaultSyncStream = NULL;
  this->sharedNetworkData = SharedNetworkData::getInstance();

  PRINTF(0)("NetworkManager created\n");
}


/**
 *  standard deconstructor
 */
NetworkManager::~NetworkManager()
{}


/**
 *  initializes the network manager
 */
void NetworkManager::initialize()
{
  /* get the synchronizeable list from the class list */
  this->netStreamList = ClassList::getList(CL_SYNCHRONIZEABLE);
  PRINTF(0)("NetworkManager initzalized\n");
}


/**
 *  shutsdown the network manager
 */
void NetworkManager::shutdown()
{

}


/**
 *  creates a connection from one object to a host
 * @param hostName: the name of the destination host
 */
int NetworkManager::establishConnection(const char* name, unsigned int port)
{
  IPaddress ipAddress;
  int error = SDLNet_ResolveHost(&ipAddress, name, port);
  if( error == -1) {
    printf("\n\nerror on address resolution, program inconsistency\n\n");
    return -1;
  }

  this->defaultSyncStream = new NetworkStream(ipAddress);
  this->sharedNetworkData->setDefaultSyncStream(this->defaultSyncStream);
  this->defaultSyncStream->startHandshake();
  return 1;
}


/**
 *  creates a new NetworkStream of server type
 * @param port: number of the TCP port
 */
int NetworkManager::createServer(unsigned int port)
{
  this->sharedNetworkData->setHostID(0);
  this->sharedNetworkData->setGameServer(true);
  this->defaultSyncStream = new NetworkStream(port);
  this->sharedNetworkData->setDefaultSyncStream(this->defaultSyncStream);
  this->defaultSyncStream->createNetworkGameManager();
  PRINTF(0)("CREATE SERVER\n");
  SDL_Delay(20);
  return 1;
}


void NetworkManager::connectSynchronizeable(Synchronizeable& sync)
{
  if( this->defaultSyncStream)
    this->defaultSyncStream->connectSynchronizeable(sync);
}


/**
 *  sync the network
 */
void NetworkManager::synchronize()
{
  if (this->netStreamList != NULL || (this->netStreamList = ClassList::getList(CL_NETWORK_STREAM)) != NULL)
  {
    std::list<BaseObject*>::const_iterator stream;
    for (stream = this->netStreamList->begin(); stream != this->netStreamList->end(); ++stream)
      if( static_cast<NetworkStream*>(*stream)->isActive())
        static_cast<NetworkStream*>(*stream)->processData();
  }
}



/**
 * debug output
 */
 void NetworkManager::debug()
{
  PRINT(0)("=================Network::debug()=========\n");
  this->defaultSyncStream->debug();
  PRINT(0)("===========================================\n");
}
