/*!
 * @file shared_network_data.h
 *  some shared data from the NetworkManager
 */

#ifndef _SHARED_NETWORK_DATA
#define _SHARED_NETWORK_DATA

#include "base_object.h"


class NetworkStream;
class Synchronizeable;
template<typename>
    class tList;

/* and here is the class itsself*/
class SharedNetworkData : public BaseObject
{

  public:
    inline static SharedNetworkData* getInstance() { if (!SharedNetworkData::singletonRef) SharedNetworkData::singletonRef = new SharedNetworkData();
      return SharedNetworkData::singletonRef; }
    virtual ~SharedNetworkData();

    /** @returns the next uniqueID free for an object */
    inline int getNewUniqueID() { return ( this->bGameServer)?this->newUniqueID++:-1; }

    /** @returns true is this node is a game server */
    inline bool isGameServer() { return this->bGameServer; }
    /** sets the game server flag @param bGameServer true if it is a game server */
    inline void setGameServer(bool bGameServer) { this->bGameServer = bGameServer; }

    /** @returns the hostID of the node */
    inline int getHostID() { return this->hostID; }
    /** sets the hostID of this node @param hostID of the node */
    inline void setHostID(int hostID) { this->hostID = hostID; }

    /** @returns the default synchronize stream */
    inline NetworkStream* getDefaultSyncStream() { return this->defaultSyncStream; }
    /** sets the default sync stream @param defaultSyncStream the default sync stream */
    inline void setDefaultSyncStream(NetworkStream* defaultSyncStream) { this->defaultSyncStream = defaultSyncStream; }


  private:
    SharedNetworkData();


  private:
    int                             newUniqueID;             //!< next uniqueID
    bool                            bGameServer;             //!< true if it is a server
    int                             hostID;                  //!< The Host-ID of the Manager
    NetworkStream*                  defaultSyncStream;       //!< default synchronize NetworkStream

    static SharedNetworkData*       singletonRef;            //!< Pointer to the only instance of this Class

};



#endif /* _SHARED_NETWORK_DATA */
