/*
   orxonox - the future of 3D-vertical-scrollers

   Copyright (C) 2004 orx

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   ### File Specific:
   main-programmer: Benjamin Grauer
   co-programmer: ...
*/

//#define DEBUG_SPECIAL_MODULE DEBUG_MODULE_

#include "ammo_container.h"

#include "weapon.h"

#include <assert.h>

using namespace std;

/**
 * standard constructor
 * @todo this constructor is not jet implemented - do it
*/
AmmoContainer::AmmoContainer (ClassID projectileType, float maxEnergy)
{
   this->setClassID(CL_AMMO_CONTAINER, "AmmoContainer");


}


/**
 * standard deconstructor
*/
AmmoContainer::~AmmoContainer ()
{
  // delete what has to be deleted here
}



float AmmoContainer::increaseEnergy(float energy)
{
  this->energy += energy;

  if (unlikely(this->energy > this->maxEnergy))
  {
    float retEnergy = this->energy - this->maxEnergy;
    this->energy = this->maxEnergy;
    return retEnergy;
  }
  else
    return 0.0f;
}


float AmmoContainer::decreaseEnergy(float energy)
{
  this->energy -= energy;

  if (unlikely(this->energy < 0))
  {
    float retEnergy = 0 - this->energy;
    this->energy = 0;
    return retEnergy;
  }
  else
    return 0.0f;
}

bool AmmoContainer::weaponValid(const Weapon* weapon)
{
  return (weapon->isA(this->projectileType));
}


void AmmoContainer::fillWeapon(Weapon* weapon)
{
  assert (weapon != NULL);
  assert (this->weaponValid(weapon));

  float fillEnergy = weapon->getEnergyMax();

  float restEnergy = weapon->increaseEnergy(fillEnergy);
  this->decreaseEnergy(fillEnergy - restEnergy);
}
