/*!
 * @file dot_particles.h

*/

#ifndef _DOT_PARTICLE_SYSTEM_H
#define _DOT_PARTICLE_SYSTEM_H

#include "particle_system.h"
#include "material.h"

//! A class to handle ParticleSystems
class DotParticles : public ParticleSystem
{

public:
  DotParticles(unsigned int maxCount = PARTICLE_DEFAULT_MAX_COUNT);
  DotParticles(const TiXmlElement* root);
  virtual ~DotParticles();

  virtual void loadParams(const TiXmlElement* root);

  void setMaterialTexture(const char* textureFile);

  /** @returns the Material that lies on this particles */
  inline const Material* getMaterial() const { return &this->material; };

  virtual void draw() const;

private:
  void init();

private:
  Material          material;            //!< A Material for all the Particles.
};

#endif /* _DOT_PARTICLE_SYSTEM_H */
