/*!
 * @file multi_type.h
 * @brief Definition of ...
 */

#ifndef _MULTI_TYPE_H
#define _MULTI_TYPE_H

// FORWARD DECLARATION

//! An enumerator defining Types, that can be stored inside a MultiType.
typedef enum
{
  MT_NULL            = 0,                  //!< No Value at all.
  MT_BOOL            = 1,                  //!< A bool Value.
  MT_INT             = 2,                  //!< An int Value.
  MT_UINT            = 2,
  MT_LONG            = 2,
  MT_FLOAT           = 4,                  //!< A float Value.
  MT_CHAR            = 8,                  //!< A single char.
  MT_STRING          = 16,                 //!< An entire String.
  MT_EXT1            = 32,                 //!< An external Type.
  MT_EXT2            = 64,                 //!< An external Type.
} MT_Type;



//! A class that encapsulates multiple differen types.
/**
 * Only one Value can be Stored inside this Class, but it can have any type: @see MT_Type.
 */
class MultiType {

  public:
    MultiType();
    MultiType(bool value);
    MultiType(int value);
    MultiType(double value);
    MultiType(char value);
    MultiType(const char* value);
    MultiType(const MultiType& multiType);
    virtual ~MultiType();

    MultiType& operator=(const MultiType& mt);
    bool operator==(const MultiType& mt) const;
    bool operator==(bool value) const { return this->getBool() == value; };
    bool operator==(int value)const { return this->getInt() == value; };
    bool operator==(float value)const { return this->getFloat() ==  value; };
    bool operator==(char value) const { return this->getChar() == value; };
    bool operator==(const char* value) const;

    void setType(int type);

    void setBool(bool value);
    void setInt(int value);
    void setFloat(float value);
    void setChar(char value);
    void setString(const char* value);

    inline void setValue(bool value) { this->setBool(value); };
    inline void setValue(int value) { this->setInt(value); };
    inline void setValue(float value) { this->setFloat(value); };
    inline void setValue(char value) { this->setChar(value); };
    inline void setValue(const char* value) { this->setString(value); };

    /** @returns the Type of the Value stored in this MultiType */
    inline MT_Type getType() const { return this->type; };


    /* RETRIEVING FUNCTIONS */
    bool getBool() const;
    int getInt() const;
    float getFloat() const;
    char getChar() const;
    const char* getString();

    void reset();

    void debug();

    static const char* MultiTypeToString(MT_Type type);
    static MT_Type StringToMultiType(const char* type);

  private:
    void init();


  private:

    union MultiTypeValue
    {
      bool              Bool;
      int               Int;
      float             Float;
      char              Char;
      char*             String;

    }                   value;

    MT_Type             type;

    char*               storedString;
};

#endif /* _MULTI_TYPE_H */
