/*!
 * @file aiming_turret.h
*/


#ifndef _TARGETING_TURRET_H
#define _TARGETING_TURRET_H

#include "weapon.h"

/* FORWARD DECLARATION */
class Aim;

class TargetingTurret : public Weapon
  {
  public:
    TargetingTurret ();
    TargetingTurret(const TiXmlElement* root);
    virtual ~TargetingTurret ();

    void init();
    virtual void loadParams(const TiXmlElement* root);

    virtual void activate();
    virtual void deactivate();

    virtual void tick(float dt);
    virtual void fire();
    virtual void destroy();

    virtual void draw() const;

  private:
    Aim*           target;
    PNode*         lockedTarget;
    float          lockedTime;
    float          neededLockTime;
  }; 

#endif /* _TARGETING_TURRET_H */
