/*!
 * @file aim.h
 *  Definition of
 */

#ifndef _AIM_H
#define _AIM_H

#include "p_node.h"
#include "element_2d.h"

// FORWARD DECLARATION
class Model;
class Text;
class Material;
class TiXmlElement;
template<class T> class tAnimation;

//! An Aim for zooming in on Targets.
/**
 * An Aim is a PNode, that is connected, to the Target, it has aquired
 * The target becomes, if selected its Parent.
 *
 * Also the Aim is a Element2D, as it draws a cross onto the Target.
 */
class Aim : public PNode, public Element2D {

 public:
  Aim(PNode* source, const TiXmlElement* root = NULL);
  virtual ~Aim();

  void init();
  virtual void loadParams(const TiXmlElement* root);

  inline void setSource(PNode* source) { this->source = source; };

  inline void selectTarget(PNode* target) { this->setParent(target); };
  inline PNode* getTarget(PNode* target) { return this->getParent(); };

  void searchTarget();

  void setRange(float range){this->range = range;};
  void setAngle(float angle){this->angle = angle;};

  void setSize(float size);
  void setTexture(const char* textureFile);
  /** @param rotationSpeed the speed at what the crosshair should rotate */
  inline void setRotationSpeed(float rotationSpeed) { this->rotationSpeed = rotationSpeed; };

  virtual void tick(float dt);
  virtual void draw() const;

 private:
   Material*        material;             //!< a material for the Aim.
   float            rotationSpeed;        //!< Speed of the Rotation.
   tAnimation<Aim>* anim;

   float            range;                //!<
   float            angle;                //!<

   PNode*           source;               //!< Where this Shot has come from.

   Text*            text;                 //!< A Text to display onto this Node. (distance to Target)
};

#endif /* _AIM_H */
