
/*!
 * @file helicopter.h
 * Implements the Control of a Hover
 */

#ifndef _HOVER_H
#define _HOVER_H

#include "playable.h"


class Hover : public Playable
{

  public:

    Hover();
    Hover(const char* fileName);
    Hover(const TiXmlElement* root);
    virtual ~Hover();

    void init();
    void loadParams(const TiXmlElement* root);

    virtual void enter();
    virtual void leave();

    virtual void postSpawn();
    virtual void leftWorld();

    virtual void collidesWith(WorldEntity* entity, const Vector& location);
    virtual void tick(float time);
    virtual void draw() const;

    virtual void process(const Event &event);



  private:
    void calculateVelocity(float time);
    void weaponAction();

    // !! temporary !!
    void ADDWEAPON();

    bool                  bUp;                //!< up button pressed.
    bool                  bDown;              //!< down button pressed.
    bool                  bLeft;              //!< left button pressed.
    bool                  bRight;             //!< right button pressed.
    bool                  bAscend;            //!< ascend button pressed.
    bool                  bDescend;           //!< descend button presses.
    bool                  bFire;              //!< fire button pressed.
    bool                  bRollL;             //!< rolling button pressed (left)
    bool                  bRollR;             //!< rolling button pressed (right)

    float                 xMouse;             //!< mouse moved in x-Direction
    float                 yMouse;             //!< mouse moved in y-Direction
    float                 mouseSensitivity;   //!< the mouse sensitivity

    Vector                velocity;           //!< the velocity of the player.
    Vector                velocityDir;        //!< the direction of the velocity of the spaceship
    float                 travelSpeed;        //!< the current speed of the player (to make soft movement)
    float                 acceleration;       //!< the acceleration of the player.
    
    float                 airViscosity;

};

#endif /* _HOVER_H */
