/*!
 * @file model_particles.h

*/

#ifndef _MODEL_PARTICLE_SYSTEM_H
#define _MODEL_PARTICLE_SYSTEM_H

#include "particle_system.h"
#include "material.h"

//! A class to handle ParticleSystems
class ModelParticles : public ParticleSystem
{
public:
  ModelParticles(unsigned int maxCount = PARTICLE_DEFAULT_MAX_COUNT);
  ModelParticles(const TiXmlElement* root);
  virtual ~ModelParticles();

  virtual void loadParams(const TiXmlElement* root);

  void setMaterialTexture(const char* textureFile);

  /** @returns the Material that lies on this particles */
  inline const Material* getMaterial() const { return &this->material; };

  virtual void draw() const;

private:
  void init();

private:
  Material          material;            //!< A Material for all the Particles.
};

#endif /* _MODEL_PARTICLE_SYSTEM_H */
