/*!
 * @file sprite_particles.h

*/

#ifndef _SPRITE_PARTICLE_SYSTEM_H
#define _SPRITE_PARTICLE_SYSTEM_H

#include "particle_system.h"
#include "material.h"

//! A class to handle ParticleSystems
class SpriteParticles : public ParticleSystem
{

public:
  SpriteParticles(unsigned int maxCount = PARTICLE_DEFAULT_MAX_COUNT);
  SpriteParticles(const TiXmlElement* root);
  virtual ~SpriteParticles();

  virtual void loadParams(const TiXmlElement* root);

  void setMaterial(Material* material);
  void setMaterialTexture(const char* textureFile);

  /** @returns the Material that lies on this particles */
  inline const Material* getMaterial() const { return &this->material; };

  virtual void draw() const;

private:
  void init();

private:
  Material          material;            //!< A Material for all the Particles.
};

#endif /* _SPRITE_PARTICLE_SYSTEM_H */
