/*!
 * @file spark_particles.h

*/

#ifndef _SPARK_PARTICLE_SYSTEM_H
#define _SPARK_PARTICLE_SYSTEM_H

#include "particle_system.h"
#include "material.h"

//! A class to handle ParticleSystems
class SparkParticles : public ParticleSystem
{

public:
  SparkParticles(unsigned int maxCount = PARTICLE_DEFAULT_MAX_COUNT);
  SparkParticles(const TiXmlElement* root);
  virtual ~SparkParticles();

  virtual void loadParams(const TiXmlElement* root);

  virtual void draw() const;

private:
  void init();

private:
  Material          material;            //!< A Material for all the Particles.
};

#endif /* _SPARK_PARTICLE_SYSTEM_H */
